% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/util.R
\name{observedSumScore}
\alias{observedSumScore}
\title{Compute the observed sum-score}
\usage{
observedSumScore(grp, ..., mask, summary = TRUE)
}
\arguments{
\item{grp}{a list with spec, param, and data}

\item{...}{Not used.  Forces remaining arguments to be specified by name.}

\item{mask}{a vector of logicals indicating which items to include}

\item{summary}{whether to return a summary (default) or per-row scores}
}
\description{
Compute the observed sum-score
}
\examples{
spec <- list()
spec[1:3] <- rpf.grm(outcomes=3)
param <- sapply(spec, rpf.rparam)
data <- rpf.sample(5, spec, param)
colnames(param) <- colnames(data)
grp <- list(spec=spec, param=param, data=data)
observedSumScore(grp)
}
