% Generated by roxygen2 (4.0.1): do not edit by hand
\name{multinomialFit}
\alias{multinomialFit}
\title{Multinomial fit test}
\usage{
multinomialFit(grp, ..., method = "lr", log = TRUE, .twotier = TRUE)
}
\arguments{
\item{grp}{a list with the spec, param, mean, and cov describing the group}

\item{...}{Not used.  Forces remaining arguments to be specified by name.}

\item{method}{lr (default) or pearson}

\item{log}{whether to report p-value in log units}

\item{.twotier}{whether to use the two-tier optimization (default TRUE)}
}
\description{
The p-value is known to become poorly calibrated as the number of
cells becomes large (e.g. more than 1000). For accurate p-values,
you can conduct a Monte-Carlo simulation study (see examples).
}
\details{
Rows with missing data are ignored.

The full information test is described in Bartholomew & Tzamourani
(1999, Section 3).
}
\examples{
# Create an example IFA group
grp <- list(spec=list())
grp$spec[1:10] <- rpf.grm()
grp$param <- sapply(grp$spec, rpf.rparam)
colnames(grp$param) <- paste("i", 1:10, sep="")
grp$mean <- 0
grp$cov <- diag(1)
grp$free <- grp$param != 0
grp$data <- rpf.sample(1000, grp=grp)

# Monte-Carlo simulation study
mcReps <- 3    # increase this to 10,000 or so
stat <- rep(NA, mcReps)
for (rx in 1:mcReps) {
   t1 <- grp
   t1$data <- rpf.sample(grp=grp)
   stat[rx] <- multinomialFit(t1)$statistic
}
sum(multinomialFit(grp)$statistic > stat)/mcReps   # better p-value
}
\references{
Bartholomew, D. J., & Tzamourani, P. (1999). The
goodness-of-fit of latent trait models in attitude
measurement. Sociological Methods and Research, 27, 525-546.
}

