% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class_core_parameter_set.R
\name{as.matrix.FieldSet}
\alias{as.matrix.FieldSet}
\title{Coerce Field Set to a Matrix}
\usage{
\method{as.matrix}{FieldSet}(x, ..., enforceRowNames = TRUE, niceColumnNamesEnabled = TRUE)
}
\arguments{
\item{x}{A \code{\link{FieldSet}} object.}

\item{...}{Ensures that all arguments (starting from the "...") are to be named and 
that a warning will be displayed if unknown arguments are passed.}

\item{enforceRowNames}{If \code{TRUE}, row names will be created
depending on the object type, default is \code{TRUE}.}

\item{niceColumnNamesEnabled}{Logical. If \code{TRUE}, nice looking column 
names will be used; syntactic names (variable names) otherwise 
(see \code{\link[base]{make.names}}).}
}
\value{
Returns a \code{\link[base]{matrix}}.
}
\description{
Returns the \code{FrameSet} as matrix.
}
\details{
Coerces the frame set to a matrix.
}
\keyword{internal}
