% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/f_analysis.R
\name{getFinalConfidenceInterval}
\alias{getFinalConfidenceInterval}
\title{Get Final Confidence Interval}
\usage{
getFinalConfidenceInterval(design, dataInput, ...)
}
\arguments{
\item{design}{The trial design.}

\item{dataInput}{The data input.}

\item{stage}{The stage number.}

\item{thetaH0}{The null hypothesis value, default is 0 for the normal and the binary case, 
it is 1 for the survival case.      
For testing a rate in one sample, a value \code{thetaH0} in (0,1) has to be specified for 
defining the null hypothesis H0: pi= thetaH0. \cr
   For non-inferiority designs, this is the non-inferiority bound.}

\item{directionUpper}{The direction of one-sided testing. 
Default is \code{directionUpper = TRUE} which means that larger values of the 
test statistics yield smaller p-values.}

\item{normalApproximation}{The type of computation of the p-values. Default is FALSE for 
testing means (i.e., the t test is used) and TRUE for testing rates and the hazard ratio. 
For testing rates, if \code{normalApproximation = FALSE} is specified, the binomial test 
(one sample) or the test of Fisher (two samples) is used for calculating the p-values.
In the survival setting \code{normalApproximation = FALSE} has no effect.}

\item{equalVariances}{The type of t test. For testing means in two treatment groups, either 
the t test assuming that the variances are equal or the t test without assuming this, 
i.e., the test of Welch-Satterthwaite is calculated, default is \code{equalVariances = TRUE}.}
}
\value{
Returns a \code{list} containing 
\itemize{
  \item \code{finalStage}, 
  \item \code{medianUnbiased}, 
  \item \code{finalConfidenceInterval}, 
  \item \code{medianUnbiasedGeneral}, and 
  \item \code{finalConfidenceIntervalGeneral}.
}
}
\description{
Returns the final confidence interval for the parameter of interest. 
It is based on the prototype case, i.e., the test for testing a mean for 
normally distributed variables.
}
\details{
Depending on \code{design} and \code{dataInput} the final confidence interval and median unbiased estimate 
that is based on the stagewise ordering of the sample space will be calculated and returned.
Additionally, a non-standardized ("general") version is provided, use the standard deviation to obtain 
the confidence interval for the parameter of interest.
}
\examples{

design <- getDesignInverseNormal(kMax = 2)
data <- getDataset(
    n = c(20, 30),
    means = c(50, 51),
    stDevs = c(130, 140)
)
getFinalConfidenceInterval(design, dataInput = data)

# Results in:
#
# $finalStage
# [1] 2
# 
# $medianUnbiasedGeneral
# [1] 0.3546145
# 
# $finalConfidenceIntervalGeneral
# [1] 0.06967801 0.63468553
# 
# $medianUnbiased
# [1] 47.7787
# 
# $finalConfidenceInterval
# [1]  9.388012 85.513851'

}
\keyword{internal}
