% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/f_design_sample_size_calculator.R
\name{getSampleSizeRates}
\alias{getSampleSizeRates}
\title{Get Sample Size Rates}
\usage{
getSampleSizeRates(design = NULL, ..., normalApproximation = TRUE,
  riskRatio = FALSE, thetaH0 = ifelse(riskRatio, 1, 0),
  pi1 = seq(0.4, 0.6, 0.1), pi2 = 0.2, groups = 2,
  allocationRatioPlanned = NA_real_)
}
\arguments{
\item{design}{The trial design. If no trial design is specified, a fixed sample size design is used. 
In this case, \code{alpha}, \code{beta}, \code{twoSidedPower}, and \code{sided} can be directly entered as argument.}

\item{...}{Ensures that all arguments are be named and 
that a warning will be displayed if unknown arguments are passed.}

\item{normalApproximation}{If \code{normalApproximation = FALSE} is specified, the sample size 
for the case of one treatment group is calculated exactly using the binomial distribution, 
default is \code{TRUE}.}

\item{riskRatio}{If \code{riskRatio = TRUE} is specified, the sample size for one-sided 
testing of H0: \code{pi1/pi2 = thetaH0} is calculated, default is \code{FALSE}.}

\item{thetaH0}{The null hypothesis value. For one-sided testing, a value != 0 
(or != 1 for testing the risk ratio \code{pi1/pi2}) can be specified, default is \code{0} or \code{1} for difference and ratio testing, respectively.}

\item{pi1}{The assumed probability in the active treatment group if two treatment groups 
are considered, or the alternative probability for a one treatment group design, 
default is seq(0.4,0.6,0.1).}

\item{pi2}{The assumed probability in the reference group if two treatment groups are considered, default is \code{0.2}.}

\item{groups}{The number of treatment groups (1 or 2), default is \code{2}.}

\item{allocationRatioPlanned}{The planned allocation ratio for a two treatment groups design. \cr
If \code{allocationRatioPlanned = 0} is entered, the optimal allocation ratio yielding the 
smallest overall sample size is determined, default is \code{1}.}
}
\value{
Returns a \code{\link{TrialDesignPlanRates}} object.
}
\description{
Returns the sample size for testing rates in one or two samples.
}
\details{
At given design the function calculates the stage-wise (non-cumulated) and maximum sample size for testing rates.
In a two treatment groups design, additionally, an allocation ratio = n1/n2 can be specified. 
If a null hypothesis value thetaH0 != 0 for testing the difference of two rates 
thetaH0 != 1 for testing the risk ratio is specified, the sample size 
formula according to Farrington & Manning (Statistics in Medicine, 1990) is used.
Critical bounds and stopping for futility bounds are provided at the effect scale 
(rate, rate difference, or rate ratio, respectively) for each sample size calculation separately. 
For the two-sample case, the calculation here is performed at fixed pi2 as given as argument 
in the function.
}
\examples{

# Calculate the stage-wise sample sizes, maximum sample sizes, and the optimum 
# allocation ratios for a range of pi1 values when testing 
# H0: pi1 - pi2 = -0.1 within a two-stage O'Brien & Fleming design;
# alpha = 0.05 one-sided, power 1- beta = 90\%:
getSampleSizeRates(design = getDesignGroupSequential(kMax = 2, alpha = 0.05, beta = 0.1, 
    sided = 1), groups = 2, thetaH0 = -0.1, pi1 = seq(0.4, 0.55, 0.025), 
    pi2 = 0.4, allocationRatioPlanned = 0)

# Calculate the stage-wise sample sizes, maximum sample sizes, and the optimum 
# allocation ratios for a range of pi1 values when testing 
# H0: pi1 / pi2 = 0.80 within a three-stage O'Brien & Fleming design;
# alpha = 0.025 one-sided, power 1- beta = 90\%:
getSampleSizeRates(getDesignGroupSequential(kMax = 3, alpha = 0.025, beta = 0.1, 
    sided = 1), groups = 2, riskRatio = TRUE, thetaH0 = 0.80, pi1 = seq(0.3,0.5,0.025), 
    pi2 = 0.3, allocationRatioPlanned = 0)

}
