% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/overlays.R
\name{osm.points}
\alias{osm.points}
\title{Overlay points on an OSM plot}
\usage{
osm.points(x, y = NULL, epsg = 4326, toepsg = 3857, ...)
}
\arguments{
\item{x}{X coordinate vector or object as parsed by \code{xy.coords}}

\item{y}{Y coordinate vector}

\item{epsg}{EPSG code of the supplied coordinates}

\item{toepsg}{EPSG code of the projected coordinates to be ploted}

\item{...}{Args passed on to \code{points}}
}
\description{
Plot points on a plot created by \link{osm.plot}. This is a simple wrapper around
\code{points()}.
}
\examples{
\donttest{
library(rosm)
library(prettymapr)
locs <- geocode(c("wolfville, ns", "kentville, ns", "halifax, ns"))
prettymap({
  osm.plot(searchbbox("nova scotia"))
  osm.points(locs$lon, locs$lat, pch=18, cex=0.7)
})
}

}

