% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/osmplot.R
\name{osm.plot}
\alias{osm.plot}
\title{Plot Open Street Map Tiles}
\usage{
osm.plot(bbox, zoomin = 0, zoom = NULL, type = "osm",
  forcedownload = FALSE, stoponlargerequest = TRUE, fusetiles = TRUE,
  cachedir = NULL, res = 150, project = TRUE, ...)
}
\arguments{
\item{bbox}{A bounding box as generated by \code{sp::bbox()} or \code{prettymapr::searchbbox()}}

\item{zoomin}{The amount by which to adjust the automatically calculated zoom (or
manually specified if the \code{zoom} parameter is passed). Use +1 to zoom in, or -1 to zoom out.}

\item{zoom}{Manually specify the zoom level (not reccomended; adjust \code{zoomin} or
\code{res} instead.}

\item{type}{A map type; one of that returned by \link{osm.types}. User defined types are possible
by defining \code{tile.url.TYPENAME <- function(xtile, ytile, zoom){}} and passing TYPENAME
as the \code{type} argument.}

\item{forcedownload}{\code{TRUE} if cached tiles should be re-downloaded. Useful if
some tiles are corrupted.}

\item{stoponlargerequest}{By default \code{osm.plot} will only load 32 tiles at a time. If
plotting at a higher resolution it may be necessary to pass \code{true} here.}

\item{fusetiles}{\code{TRUE} if tiles should be fused into a single image. This is the
default because white lines appear between tiles if it is set to \code{FALSE}. PDFs
appear not to have this problem, so when plotting large, high resolution PDFs it may be
faster (and more memory efficient) to use \code{fusetiles=FALSE}.}

\item{cachedir}{The directory in which tiles should be cached. Defaults to \code{getwd()/rosm.cache}.}

\item{res}{The resolution used to calculate scale.}

\item{project}{\code{TRUE} if tiles should be projected to a pseudo-mercator projection,
\code{FALSE} if lat/lon should be maintained. Becuase \code{sp::plot} adjusts the aspect
according to latitude for lat/lon coordinates, this makes little difference at high
zoom and may make plotting overlays more convenient. Defaults to \code{TRUE}.}

\item{...}{Additional parameters to be passed on to the first call to \code{sp::plot}}
}
\description{
Plot Open Street Map tiles using \code{rasterImage} and \code{sp::plot}.
Define your own tile sources by creating a tile url function in the
global environment, although most \href{http://wiki.openstreetmap.org/wiki/Tile_servers}{OSM listed}
servers are included. See \link{osm.types} for types options. By default tiles
are plotted in the Spherical Mercator projection
(\href{https://en.wikipedia.org/wiki/Web_Mercator}{epsg:3857}); pass \code{project=FALSE}
to keep lat/lon coordinates.
}
\examples{
\donttest{
library(prettymapr)
ns <- makebbox(47.2, -59.7, 43.3, -66.4)
osm.plot(ns)
osm.plot(ns, type="mapquestsat")
prettymap(osm.plot(ns), scale.style="ticks", scale.tick.cex=0)

tile.url.darkmatter <- function(xtile, ytile, zoom) {
  paste0(paste("http://a.basemaps.cartocdn.com/dark_all",
                            zoom, xtile, ytile, sep="/"), ".png")
}
osm.plot(ns, type="darkmatter")
}
}

