% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/main.R
\name{findSimpleFunction}
\alias{findSimpleFunction}
\title{Find one value function}
\usage{
findSimpleFunction(problem)
}
\arguments{
\item{problem}{Problem}
}
\value{
List with named elements:
\itemize{
\item \code{vf} - list of 2-column matrices with marginal value functions (characteristic point in rows),
\item \code{thresholds},
\item \code{assignments},
\item \code{alternativeValues},
\item \code{epsilon}.
}
}
\description{
This function finds single value function that is consistent with provided preferece information.
Search is done by epsilon maximization.
}
\examples{
perf <- matrix(c(5, 2, 1, 7, 0.5, 0.9, 0.4, 0.4), ncol = 2)
problem <- buildProblem(perf, 3, FALSE, c('g', 'g'), c(0, 0))
problem <- addAssignmentsLB(problem, c(1, 2), c(2, 3))

simpleFunction <- findSimpleFunction(problem)
}
\seealso{
\code{\link{plotVF}}
\code{\link{plotComprehensiveValue}}
\code{\link{findRepresentativeFunction}}
}

