% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utility_functions.R
\name{createMatches}
\alias{createMatches}
\title{Algorithm to find best matches from the comparison pool
As it's an internal helper function to aid in testing, it is not exported for use outside of the package.}
\usage{
createMatches(trimmed_pool, num_matches = 3, replacement = TRUE)
}
\arguments{
\item{num_matches}{Integer. the number of comparison beneficiary matches to
attempt to assign to each treatment beneficiary}

\item{replacement}{Boolean. Assign comparison beneficiaries with replacement
(TRUE) or without replacement (FALSE). If \code{replacement} is TRUE, then
comparison beneficiaries will be allowed to be used with replacement within
a single quarter, but will be allowed to match to different treatment
beneficiaries across multiple quarters.}

\item{comparison_pool}{Dataframe containing the pool from which matches
should be found}
}
\value{
Dataframe containing top matches
}
\description{
Algorithm to find best matches from the comparison pool
As it's an internal helper function to aid in testing, it is not exported for use outside of the package.
}
\examples{
\dontrun{ 
num_matches <- 3; replacement <- TRUE
load(url(paste0("https://github.com/RTIInternational/rollmatch/raw/master/",
                "tests/testthat/trimmed_pool.rda")))
matches <- createMatches(trimmed_pool, num_matches, replacement)
head(matches)
}

}
\keyword{internal}
