% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/flat_table.R, R/generic.R, R/star_database.R
\name{set_measure_names.flat_table}
\alias{set_measure_names.flat_table}
\alias{set_measure_names}
\alias{set_measure_names.star_database}
\title{Rename measures}
\usage{
\method{set_measure_names}{flat_table}(db, name = NULL, old = NULL, new)

set_measure_names(db, name, old, new)

\method{set_measure_names}{star_database}(db, name = NULL, old = NULL, new)
}
\arguments{
\item{db}{A \code{flat_table} or \code{star_database} object.}

\item{name}{A string, fact name.}

\item{old}{A vector of names.}

\item{new}{A vector of names.}
}
\value{
A \code{flat_table} or \code{star_database} object.
}
\description{
Rename measures in a flat table or in facts in a star database.
}
\details{
To rename the measures there are three possibilities: 1) give only one vector
with the new names for all the measures; 2) a vector of old names and another
of new names that must correspond; 3) a vector of new names whose names are
the old names they replace.
}
\examples{

db <- star_database(mrs_cause_schema, ft_num) |>
  set_measure_names(
    new = c(
      "Pneumonia and Influenza",
      "All",
      "Rows Aggregated"
    )
  )

ft <- flat_table('iris', iris) |>
  set_measure_names(
    old = c('Petal.Length', 'Petal.Width', 'Sepal.Length', 'Sepal.Width'),
    new = c('pl', 'pw', 'ls', 'sw'))

new <- c('pl', 'pw', 'ls', 'sw')
names(new) <- c('Petal.Length', 'Petal.Width', 'Sepal.Length', 'Sepal.Width')
ft <- flat_table('iris', iris) |>
  set_measure_names(
    new = new)

}
\seealso{
\code{\link{star_database}}, \code{\link{flat_table}}

Other star database and flat table functions: 
\code{\link{get_attribute_names.flat_table}()},
\code{\link{get_measure_names.flat_table}()},
\code{\link{get_similar_attribute_values.flat_table}()},
\code{\link{get_similar_attribute_values_individually.flat_table}()},
\code{\link{get_unique_attribute_values.flat_table}()},
\code{\link{replace_attribute_values.flat_table}()},
\code{\link{set_attribute_names.flat_table}()},
\code{\link{snake_case.flat_table}()}
}
\concept{star database and flat table functions}
