% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/refresh.R
\name{get_transformation_code}
\alias{get_transformation_code}
\alias{get_transformation_code.star_database_update}
\title{Get transformation function code}
\usage{
get_transformation_code(sdbu)

\method{get_transformation_code}{star_database_update}(sdbu)
}
\arguments{
\item{sdbu}{A \code{star_database_update} object.}
}
\value{
A vector of strings.
}
\description{
From the planned update, it obtains the function with the source code of the
transformations performed on the original data in string vector format.
}
\examples{

f1 <- flat_table('ft_num', ft_cause_rpd) |>
  as_star_database(mrs_cause_schema_rpd) |>
  replace_attribute_values(
    name = "When Available",
    old = c('1962', '11', '1962-03-14'),
    new = c('1962', '3', '1962-01-15')
  ) |>
  group_dimension_instances(name = "When")
f2 <- flat_table('ft_num2', ft_cause_rpd) |>
  update_according_to(f1)
code <- f2 |>
  get_transformation_code()

}
\seealso{
Other star database refresh functions: 
\code{\link{get_existing_fact_instances}()},
\code{\link{get_lookup_tables}()},
\code{\link{get_new_dimension_instances}()},
\code{\link{get_star_database}()},
\code{\link{get_star_schema}()},
\code{\link{get_transformation_file}()},
\code{\link{incremental_refresh}()},
\code{\link{update_according_to}()}
}
\concept{star database refresh functions}
