% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/star_database.R
\name{snake_case}
\alias{snake_case}
\alias{snake_case.star_database}
\title{Transform names according to the snake case style}
\usage{
snake_case(db)

\method{snake_case}{star_database}(db)
}
\arguments{
\item{db}{A \code{star_database} object.}
}
\value{
A \code{star_database} object.
}
\description{
Transform fact, dimension, measures, and attribute names according to the
snake case style.
}
\details{
This style is suitable if we are going to work with databases.
}
\examples{

s <- star_schema() |>
  define_facts(fact_schema(
    name = "mrs_cause",
    measures = c(
      "Pneumonia and Influenza Deaths",
      "All Deaths"
    )
  )) |>
  define_dimension(dimension_schema(
    name = "when",
    attributes = c(
      "Year"
    )
  )) |>
  define_dimension(dimension_schema(
    name = "where",
    attributes = c(
      "REGION",
      "State",
      "City"
    )
  ))

# ft_num contains instances
db <- star_database(s, ft_num) |>
  snake_case()

}
\seealso{
\code{\link{as_tibble_list}}, \code{\link{as_dm_class}}

Other star database and constellation definition functions: 
\code{\link{constellation}()},
\code{\link{get_dimension_attribute_names}()},
\code{\link{get_fact_measure_names}()},
\code{\link{get_role_playing_dimension_names}()},
\code{\link{role_playing_dimension}()},
\code{\link{set_dimension_attribute_names}()},
\code{\link{set_fact_measure_names}()},
\code{\link{star_database}()}
}
\concept{star database and constellation definition functions}
