% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/authentication.R
\name{set_username_and_password}
\alias{set_username_and_password}
\title{Set Username, Password, and Server URL for API Authentication}
\usage{
set_username_and_password(username, password, server_url)
}
\arguments{
\item{username}{A character string containing the API username.}

\item{password}{A character string containing the API password.}

\item{server_url}{A character string containing the URL of the ODK-X sync endpoint (e.g., "https://my.sync-endpoint.com").}
}
\value{
A message confirming that credentials and server URL have been set.
}
\description{
This function sets the environment variables \code{ROCKX_USERNAME}, \code{ROCKX_PASSWORD}, and \code{ROCKX_SERVER_URL} for authentication and specifying the ODK-X Sync Endpoint.
}
\examples{
rockx::set_username_and_password("my_user", "my_password", "https://my.sync-endpoint.com")

}
