% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ci_heatmap.R
\name{ci_heatmap}
\alias{ci_heatmap}
\title{Create a heatmap showing issues with items}
\usage{
ci_heatmap(
  x,
  itemIdentifier = "uiid",
  codingScheme = "peterson",
  itemlab = "Item",
  codelab = "Code",
  freqlab = "Frequency",
  plotTitle = "Cognitive Interview Heatmap",
  fillScale = ggplot2::scale_fill_viridis_c(),
  theme = ggplot2::theme_minimal()
)
}
\arguments{
\item{x}{The object with the parsed coded source(s) as resulting from a
call to \code{\link[=parse_source]{parse_source()}} or \code{\link[=parse_sources]{parse_sources()}}.}

\item{itemIdentifier}{The column identifying the items.}

\item{codingScheme}{The coding scheme, either as a string if it represents
one of the cognitive interviewig coding schemes provided with the \code{rock}
package, or as a coding scheme resulting from a call
to \code{\link[=create_codingScheme]{create_codingScheme()}}.}

\item{itemlab, codelab, freqlab}{Labels to use for the item and code axes
and for the frequency color legend.}

\item{plotTitle}{The title to use for the plot}

\item{fillScale}{Convenient way to specify the fill scale (the colours)}

\item{theme}{Convenient way to specify the \code{\link[ggplot2:ggplot]{ggplot2::ggplot()}} theme.}
}
\value{
The heatmap
}
\description{
When conducting cognitive interviews, it can be useful to quickly inspect
the code distributions for each item. These heatmaps facilitate that
process.
}
\examples{
examplePath <- file.path(system.file(package="rock"), 'extdata');
parsedCI <- parse_source(file.path(examplePath,
                                   "ci_example_1.rock"));

ci_heatmap(parsedCI,
           codingScheme = "peterson");
}
