% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vartest.R
\name{vartest}
\alias{vartest}
\title{Calibrated variance test between two or more independent samples}
\usage{
vartest(x, y, ...)
}
\arguments{
\item{x, y}{the two continuous variables for the two samples variance test.}

\item{...}{other parameters such as \code{alternative} which indicates the alternative hypothesis
as one of "two.sided", "greater" or "less", or \code{data} and \code{formula} to include a dataset with a formula
from the command \code{vartest(x~y,data=dataset)} with dataset the name of the data.}
}
\value{
Returns the result of the test with its corresponding p-value and the value of the test statistic. In the two sample case, the function
also returns the confidence interval for the difference of the two variances.
}
\description{
Tests the equality of variance for continuous independent samples using Welch's ANOVA on the square of the centered variables.
}
\details{
For the two sample variance test, the null hypothesis is: H0 var(X)=var(Y) where var represents the variance.
The alternative is specified by the \code{alternative} argument.
The test uses Welch's ANOVA procedure on the variables \eqn{(x_i-mean(x))^2}, \eqn{(y_i-mean(y))^2} and is asymptotically well calibrated in the sense that the rejection probability under the null hypothesis is asymptotically equal to the level of the test.
The test can be applied to more than two groups in which case it tests if all groups have the same variance.
}
\note{
The function can also be called using formulas: type \code{vartest(x~y,data)} with x the quantitative variable
and y a factor variable with two or more levels. For more than two groups, only the formula is valid.
}
\examples{
#Application on the Evans dataset
data(Evans)
#Description of this dataset is available in the lbreg package
with(Evans,var.test(CHL[CDH==0],CHL[CDH==1]))
with(Evans,vartest(CHL[CDH==0],CHL[CDH==1]))
vartest(CHL~CDH,data=Evans) #using formulas

#Similar pvalues between var.test and vartest

\donttest{
#Simulated data
n=60 #sample size
M=10000 #number of replications
testone=function(n){
X=rnorm(n,0,1)
Y=rchisq(2*n,df=2)/2
list(test1=vartest(X,Y)$p.value,test2=var.test(X,Y)$p.value) #var.test is the standard Fisher test
}
res1=res2=rep(NA,M)
# Replications to check if the corrected Fisher test and the standard test are well calibrated
for (i in 1:M)
{
result=testone(n)
res1[i]=result$test1
res2[i]=result$test2
}
mean(res1<0.05)  #0.0515
mean(res2<0.05)  #0.1509}

}
\seealso{
\code{\link{cortest}}, \code{\link{indeptest}}, \code{\link{mediantest}}, \code{\link{wilcoxtest}}.
}
\keyword{test}
