% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/robregcc.R
\name{robregcc_option}
\alias{robregcc_option}
\title{Control  parameter for model estimation:}
\usage{
robregcc_option(maxiter = 10000, tol = 1e-10, nlam = 100,
  out.tol = 1e-08, lminfac = 1e-08, lmaxfac = 10, mu = 1,
  nu = 1.05, sp = 0.3, gamma = 2, outMiter = 3000, inMiter = 500,
  kmaxS = 500, tolS = 1e-04, nlamx = 20, nlamy = 20, spb = 0.3,
  spy = 0.3, lminfacX = 1e-06, lminfacY = 0.01, kfold = 5,
  fullpath = 0)
}
\arguments{
\item{maxiter}{maximum number of iteration for convergence}

\item{tol}{tolerance value set for convergence}

\item{nlam}{number of lambda to be genrated to obtain solution path}

\item{out.tol}{tolernce value set for convergence of outer loop}

\item{lminfac}{a multiplier of determing lambda_min as a fraction of lambda_max}

\item{lmaxfac}{a multiplier of lambda_max}

\item{mu}{penalty parameter used in enforcing orthogonality}

\item{nu}{penalty parameter used in enforcing orthogonality (incremental rate of mu)}

\item{sp}{maximum proportion of nonzero elements in shift parameter}

\item{gamma}{adaptive penalty weight exponential factor}

\item{outMiter}{maximum number of outer loop iteration}

\item{inMiter}{maximum number of inner loop iteration}

\item{kmaxS}{maximum number of iteration for fast S estimator for convergence}

\item{tolS}{tolerance value set for convergence in case of fast S estimator}

\item{nlamx}{number of x lambda}

\item{nlamy}{number of y lambda}

\item{spb}{sparsity in beta}

\item{spy}{sparsity in shift gamma}

\item{lminfacX}{a multiplier of determing lambda_min as a fraction of lambda_max for sparsity in X}

\item{lminfacY}{a multiplier of determing lambda_min as a fraction of lambda_max for sparsity in shift parameter}

\item{kfold}{nummber of folds for crossvalidation}

\item{fullpath}{1/0 to get full path yes/no}
}
\value{
a list of controling parameter.
}
\description{
The model approach use scaled lasoo approach for model selection.
}
\examples{
 
library(robregcc)
# default options
control_default = robregcc_option()
# manual options
control_manual <- robregcc_option(maxiter=1000,tol = 1e-4,lminfac = 1e-7)
}
