% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/export_pptx.R
\name{export_pptx}
\alias{export_pptx}
\alias{export_pptx.flextable}
\alias{export_pptx.default}
\title{Export a flextable of results from (robust) mediation analysis to 'Microsoft
Powerpoint'}
\usage{
export_pptx(object, file, ...)

\method{export_pptx}{flextable}(object, file, ...)

\method{export_pptx}{default}(object, file, ...)
}
\arguments{
\item{object}{an object of class \code{"\link[flextable]{flextable}"}, or
an object containing results from (robust) mediation analysis that can be
converted to the subclass \code{"mediation_flextable"} via
\code{\link{to_flextable}()}.}

\item{file}{a character string specifying the path an file name for the
\proglang{Microsoft Powerpoint} file to be generated.}

\item{\dots}{for the \code{"flextable"} method, additional arguments to
be passed down to \code{\link[officer]{prop_section}()} for defining page
composition such as page size, page orientation, and margins.  For the
default method, additional arguments to be passed down to
\code{\link{to_flextable}()} for converting results from (robust)
mediation analysis.}
}
\value{
The function is called for its side effect of creating a \proglang{Microsoft
Powerpoint} file.  It returns the path to the file invisibly.
}
\description{
Export a \code{\link[flextable]{flextable}} object to \proglang{Microsoft
Powerpoint}.  This function is intended for tables of results from (robust)
mediation analysis.  It is essentially a wrapper for
\code{\link[flextable]{save_as_pptx}()}.
}
\examples{
data("BSG2014")

# seed to be used for the random number generator
seed <- 20211117

# perform mediation analysis via robust bootstrap test ROBMED
set.seed(seed)
robust_boot <- test_mediation(BSG2014,
                              x = "ValueDiversity",
                              y = "TeamCommitment",
                              m = "TaskConflict",
                              robust = TRUE)

# construct flextable of results
ft <- to_flextable(robust_boot)

# export to Microsoft Powerpoint
file_name <- tempfile(fileext = ".pptx")
export_pptx(ft, file = file_name)

}
\seealso{
\code{\link{export_docx}()}

\code{\link[flextable]{flextable}()}, \code{\link{to_flextable}()}
}
\author{
Andreas Alfons
}
