% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ROBIN.R
\name{robinFDATest}
\alias{robinFDATest}
\title{robinFDATest}
\usage{
robinFDATest(graph, model1, model2, measure = c("vi", "nmi",
  "split.join", "adjusted.rand"), legend = c("real data", "null model"))
}
\arguments{
\item{graph}{The output of prepGraph.}

\item{model1}{The Mean output of the robinRobust function (or the Mean1 
output of the comparison function).}

\item{model2}{The MeanRandom output of the robinRobust function (or the 
Mean2 output of the comparison function).}

\item{measure}{The stability measure "vi", "nmi", "split.join", 
"adjusted.rand".}

\item{legend}{The legend for the graph. The default is c("real data", 
"null model").}
}
\value{
Two plots.
}
\description{
The function implements the Interval Testing Procedure for 
testing the difference between the two curves.
}
\examples{
my_file <- system.file("example/football.gml", package="robin")
graph <- prepGraph(file=my_file, file.format="gml")
graphRandom <- random(graph=graph)
Proc <- robinRobust(graph=graph, graphRandom=graphRandom, method="louvain",
measure="vi",type="independent")
robinFDATest(graph=graph, model1=Proc$Mean, model2=Proc$MeanRandom)
}
