context("Test coordinates")

test_that("Test grid references with different length", {

    expect_that(osg_parse("SN9491282412"),
                equals(structure(list(easting = 294912, northing = 282412),
                                 .Names = c("easting", "northing"))))

    expect_that(osg_parse("SN94918241"),
                equals(structure(list(easting = 294910, northing = 282410),
                                 .Names = c("easting", "northing"))))

    expect_that(osg_parse("SN949824"),
                equals(structure(list(easting = 294900, northing = 282400),
                                 .Names = c("easting", "northing"))))

    expect_that(osg_parse("SN9482"),
                equals(structure(list(easting = 294000, northing = 282000),
                                 .Names = c("easting", "northing"))))

    closeAllConnections()

})

test_that("Test grid references from various areas", {

    expect_that(osg_parse("TQ722213"),
                equals(structure(list(easting = 572200, northing = 121300),
                                 .Names = c("easting", "northing"))))

    expect_that(osg_parse(c("SN831869","SN829838")),
                equals(structure(list(easting = c(283100, 282900),
                                      northing = c(286900, 283800)),
                                 .Names = c("easting", "northing"))))

    closeAllConnections()

})



# crs 4326
wgs <- matrix(c(18.5, 54.2,
                113.4, 46.78,
                16.9, 67.8),
              byrow = TRUE, ncol = 2, dimnames = list(NULL, c("x", "y")))

# correct values from https://mygeodata.cloud/cs2cs/
# crs 3034
lccEU <- matrix(c(4535410.16093, 3067447.25856,
                  9382256.98256, 6769270.46095,
                  4295683.24203, 4544089.18176),
                byrow = TRUE, ncol = 2, dimnames = list(NULL, c("x", "y")))

# crs 3416
lccAT <- matrix(c(739233.098505, 1158123.41459,
                  6096512.30717, 4595909.41132,
                  562300.406341, 2719066.06187),
                byrow = TRUE, ncol = 2, dimnames = list(NULL, c("x", "y")))


test_that("conversion works for single crs", {
    tr <- .transform_crs(x = wgs[, "x"], y = wgs[, "y"], from = 4326, to = 3034)
    rownames(tr) <- NULL
    expect_equal(round(tr, 4), round(as.data.frame(lccEU), 4))
})


test_that("conversion works for multiple crs", {
    input <- data.frame(rbind(wgs, wgs),
                        crs = c(rep(3034, times = nrow(lccEU)),
                                rep(3416, times = nrow(lccAT))))
    idx <- sample(nrow(input))
    input <- input[idx, ]

    tr <- .transform_crs(x = input$x, y = input$y, from = 4326, to = input$crs)
    rownames(tr) <- NULL
    expect_equal(round(tr, 4),
                 as.data.frame(round(rbind(lccEU, lccAT)[idx, ], 4)))
})

test_that("vectorized version of parse_osg() returns the same values as before", {
    grid <- c("NJ9468430370", "NJ7567720150", "NO6348295613", "NO7973998317",
              "NO8264873370", "NO14753668", "NN9331316652", "NS7765895458",
              "NT4561868891", "IH4607173048", "IH3477995968", "IC4641115098",
              "IC9307615349", "IC9419136250", "IJ3287269316", "IJ4485350808",
              "NT4982333376", "NT8983647709", "NT8807755014", "NZ0385861700",
              "NY8565664671", "NZ2592313748", "SE4221547311", "SE5684555373",
              "SE7311258712", "SE7046885533", "SK62013996", "SK23742884", "SE64580122",
              "SK65294795", "SP54209732", "TF337879", "SK84204796", "TL0535349560",
              "TF7160200623", "TL8508984362", "TL1600453461", "TL9624926113",
              "TL3907409193", "TL2825613276", "TQ17786985", "SU73096478", "SU6495970828",
              "SU4703368219", "SP1214706228", "SU63457658", "SU4526669473",
              "TQ2624546209", "TQ7086553033", "TR1154955356", "TQ4290721374",
              "SU5874607460", "SU31780192", "SU35411886", "SU4612921122", "SU1510941387",
              "SZ1123396046", "SY9132287609", "SS9360201602", "SY0866588435",
              "SX7511265841", "SX1595167373", "SW8197545030", "SS6079523662",
              "ST2057625023", "ST5899431756", "SO78237616", "SP0400743741",
              "SJ41191446", "SO73495573", "SO8634939041", "SO5276911077", "SO3460605591",
              "SO0034830405", "ST0794095652", "SS6855399798", "SN4850920576",
              "NH6450742726", "SN2441941655", "SH7448901958", "SH8012958077",
              "SJ3482241459", "SH8735330798", "NJ1940262632", "SD5892230412",
              "SD5293565318", "NY3900057103", "NX9234685121", "NH9469119208",
              "NJ3185051788", "NX4126665330", "NS7043557942", "NS6718461676",
              "NS3940980307", "NS3563592880", "NN1159274257", "NJ5321746431",
              "NJ7055149833", "NG9418642885", "NG8600280330", "NC7136356765")

    osgParseOld <- matrix(
        c(-2.09001733998666, -2.40496394660203, -2.60356717479019,
          -2.33582515568165, -2.286119469396, -3.38696400046318, -3.72699296961103,
          -3.97021830564339, -2.87149765157458, -7.28785371803201, -7.4598432608806,
          -7.27587070711054, -6.54713679647, -6.52282932637446, -5.94704148210268,
          -5.77106438384339, -2.7977000766452, -2.16337313713526, -2.19169769233304,
          -1.94129656889076, -2.22562938391987, -1.60105905353711, -1.35871290831485,
          -1.13447937371317, -0.885617063369463, -0.919709905158696, -1.07845581295743,
          -1.64887503956615, -1.02781928347585, -1.02803146898454, -1.20172813145642,
          0.00810567762071144, -0.746162278574411, -0.46217750798905, 0.53100197364227,
          0.720766589748605, -0.305302862756286, 0.851040462466282, 0.0138875133825735,
          -0.141273501301447, -0.307709935040086, -0.95124457021738, -1.06694593110441,
          -1.3251363307611, -1.82542745206325, -1.08761988614384, -1.35038119067564,
          -0.194404948241513, 0.446960512638768, 1.03050807119244, 0.0341145239191814,
          -1.16663153718286, -1.55025959970684, -1.49709796528965, -1.34417140078699,
          -1.78526748953865, -1.84209394593736, -2.12420961367604, -3.51130891255678,
          -3.29433729217173, -3.7615221948251, -4.59532493201528, -5.06055821833811,
          -3.98504131022092, -3.13370763200716, -2.58679955998711, -2.32126628581147,
          -1.94292757043377, -2.87220769055374, -2.38928954660979, -2.20047423950344,
          -2.68627452476592, -2.94857815430261, -3.451797000363, -3.33208954710669,
          -3.90268692889901, -4.20146396001904, -4.2598468660508, -4.56174047786924,
          -3.85463677668523, -3.79206251798089, -2.97188702150556, -3.67469418044069,
          -3.35193320102227, -2.62468249634944, -2.72089215740217, -2.95286046247095,
          -3.69074778972718, -3.74702871428708, -3.14038804948503, -4.48052589677405,
          -4.06830559051382, -4.1219483755477, -4.57598198381193, -4.64412308700862,
          -5.08883948814424, -2.78237795381293, -2.49353335943091, -5.42999922577372,
          -5.59907694800176, -4.20774924905789, 57.3637712742882, 57.2713467610432,
          57.0501290961082, 57.0754239982482, 56.8514405567843, 56.5144141015383,
          56.3301870851999, 56.1360997970135, 55.9100321928041, 54.6035684978002,
          54.8103506584005, 54.9812349658044, 54.9769657439427, 55.1644355430757,
          54.5547160617989, 54.3852965538418, 55.5914172824981, 55.7226890799062,
          55.7882839143376, 54.9499367552854, 54.9764390800471, 54.5183706714202,
          53.9202264949106, 53.991281760769, 54.0192439203356, 54.2606205580319,
          52.953442631183, 52.8565335918293, 53.5037166651931, 53.0248674650984,
          52.5710109137109, 53.3710538948176, 53.0223204255636, 52.1343074360071,
          52.576346875905, 52.4259087092356, 52.1672329536952, 51.8989928302897,
          51.7641533495334, 51.8034244644067, 51.415443046541, 51.3773778365341,
          51.4327388816032, 51.4110495704301, 51.754613215682, 51.4846222885865,
          51.4224677637148, 51.201155048717, 51.2508695521077, 51.2581020550427,
          50.9740565287426, 50.8636714421029, 50.8159605613497, 50.9680761814191,
          50.9876588121119, 51.1715266833371, 50.7638974517534, 50.6880664355548,
          50.8041740208142, 50.6883718877523, 50.4790420081872, 50.4772073068881,
          50.2649049745737, 50.9954687583872, 51.0190745557624, 51.0836470055485,
          52.3830349552113, 52.0920010812072, 52.7245738481219, 52.1991585398133,
          52.0495880567444, 51.7963358328236, 51.7451852532379, 51.9631625668413,
          51.6520944083381, 51.6815152365549, 51.8631413947138, 57.4545365935269,
          52.0454054194456, 52.6008695584877, 53.1063752929314, 52.9665128088553,
          52.8628401896934, 57.6463693319813, 53.7684222364421, 54.0816166097278,
          54.9049033239219, 55.148684836416, 57.251391749347, 57.5510411454311,
          54.957263379008, 55.7973430557413, 55.8299869370045, 55.988771244277,
          56.1003365652645, 56.8215106492369, 57.5056463334545, 57.5376659138071,
          57.4295351374214, 57.761442003195, 58.4800721323868),
        ncol = 2, dimnames = list(NULL, c("lon", "lat")))

    wgs <- osg_parse(grid, CoordSystem = "WGS84")
    rownames(wgs) <- NULL
    expect_equal(lapply(wgs, round, digits = 4),
                 as.list(as.data.frame(round(osgParseOld, 4))))
})
