% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/npn_geoserver.R
\name{npn_get_custom_agdd_time_series}
\alias{npn_get_custom_agdd_time_series}
\title{Get Custom AGDD Time Series}
\usage{
npn_get_custom_agdd_time_series(
  method,
  start_date,
  end_date,
  base_temp,
  climate_data_source,
  temp_unit,
  lat,
  long,
  upper_threshold = NULL
)
}
\arguments{
\item{method}{Takes "simple" or "double-sine" as input. This is the AGDD calculation method to use for each
data point. Simple refers to simple averaging.}

\item{start_date}{Date at which to begin the AGDD calculations}

\item{end_date}{Date at which to end the AGDD calculations}

\item{base_temp}{This is the lowest temperature for each day  for it to be considered in the calculation.}

\item{climate_data_source}{Specified the climate data set to use. Takes either "PRISM" or "NCEP" as input.}

\item{temp_unit}{The unit of temperature to use in the calculation. Takes either "Fahrenheit" or "Celsius" as input.}

\item{lat}{The latitude of the location for which to calculate the time series}

\item{long}{The longitude of the location for which to calculate the time series}

\item{upper_threshold}{This parameter is only applicable for the double-sine method. This sets the highest temperature
to be considered in any given day's AGDD calculation}
}
\description{
This function takes a series of variables used in calculating AGDD and returns an AGDD time series,
based on start and end date, for a given location in the continental US.
This function leverages the USA-NPN geo web services
}
