% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ncdc_stations.r
\name{ncdc_stations}
\alias{ncdc_stations}
\title{Get metadata about NOAA NCDC stations.}
\usage{
ncdc_stations(stationid = NULL, datasetid = NULL, datatypeid = NULL,
  locationid = NULL, startdate = NULL, enddate = NULL,
  sortfield = NULL, sortorder = NULL, limit = 25, offset = NULL,
  datacategoryid = NULL, extent = NULL, token = NULL,
  dataset = NULL, station = NULL, location = NULL,
  locationtype = NULL, page = NULL, ...)
}
\arguments{
\item{stationid}{A single valid station id, with datasetid namespace,
e.g., GHCND:USW00014895}

\item{datasetid}{(optional) Accepts a valid dataset id or a vector or
list of them. Data returned will be from the dataset specified.}

\item{datatypeid}{Accepts a valid data type id or a vector or list of data
type ids. (optional)}

\item{locationid}{Accepts a valid location id or a vector or list of
location ids (optional)}

\item{startdate}{(optional) Accepts valid ISO formated date (yyyy-mm-dd) or date time
(YYYY-MM-DDThh:mm:ss). Data returned will have data after the specified date. The
date range must be less than 1 year.}

\item{enddate}{(optional) Accepts valid ISO formated date (yyyy-mm-dd) or date time
(YYYY-MM-DDThh:mm:ss). Data returned will have data before the specified date. The
date range must be less than 1 year.}

\item{sortfield}{The field to sort results by. Supports id, name, mindate,
maxdate, and datacoverage fields (optional)}

\item{sortorder}{Which order to sort by, asc or desc. Defaults to
asc (optional)}

\item{limit}{Defaults to 25, limits the number of results in the response.
Maximum is 1000 (optional)}

\item{offset}{Defaults to 0, used to offset the resultlist (optional)}

\item{datacategoryid}{(character, optional) Accepts a valid data category id or a
vector or list of data category ids.}

\item{extent}{(numeric, optional) The geographical extent for which you want to 
search. Give four values that defines a bounding box, lat and long for the 
southwest corner, then lat and long for the northeast corner. For example: 
\code{c(minlat, minlong, maxlat, maxlong)}.}

\item{token}{This must be a valid token token supplied to you by NCDC's
Climate Data Online access token generator. (required) See
\strong{Authentication} section below for more details.}

\item{dataset}{THIS IS A DEPRECATED ARGUMENT. See datasetid.}

\item{station}{THIS IS A DEPRECATED ARGUMENT. See stationid.}

\item{location}{THIS IS A DEPRECATED ARGUMENT. See locationid.}

\item{locationtype}{THIS IS A DEPRECATED ARGUMENT. There is no equivalent argument in v2 
of the NOAA API.}

\item{page}{THIS IS A DEPRECATED ARGUMENT. There is no equivalent argument in v2 
of the NOAA API.}

\item{...}{Curl options passed on to \code{\link[crul]{HttpClient}} 
(optional)}
}
\value{
A list of metadata.
}
\description{
From the NOAA NCDC API docs: Stations are where the data comes from
(for most datasets) and can be considered the smallest granual of location
data. If you know what station you want, you can quickly get all manner of
data from it
}
\section{Authentication}{

Get an API key (aka, token) at \url{http://www.ncdc.noaa.gov/cdo-web/token}.
You can pass your token in as an argument or store it one of two places:

\itemize{
  \item your .Rprofile file with an entry like
  \code{options(noaakey = "your-noaa-token")}
  \item your .Renviron file with an entry like
  \code{NOAA_KEY=your-noaa-token}
}

See \code{\link{Startup}} for information on how to create/find your
.Rrofile and .Renviron files
}

\examples{
\dontrun{
# Get metadata on all stations
ncdc_stations()
ncdc_stations(limit=5)

# Get metadata on a single station
ncdc_stations(stationid='COOP:010008')

# For many stations use lapply or similar
lapply(c("COOP:010008", "COOP:010063", "COOP:010116"), function(z) {
  ncdc_stations(
   startdate = "2013-01-01",
   enddate = "2014-11-01",
   stationid = z)
}$data)

# Displays all stations within GHCN-Daily (100 Stations per page limit)
ncdc_stations(datasetid = 'GHCND')
ncdc_stations(datasetid = 'ANNUAL')
ncdc_stations(datasetid = 'GSOY')

# Station
ncdc_stations(datasetid='NORMAL_DLY', stationid='GHCND:USW00014895')

# datatypeid
ncdc_stations(datatypeid="ANN-HTDD-NORMAL")
ncdc_stations(datatypeid=c("ANN-HTDD-NORMAL", "ACSC"))

# locationid
ncdc_stations(locationid="CITY:AG000001")
ncdc_stations(locationid="FIPS:30091")
ncdc_stations(locationid=c("FIPS:30103", "FIPS:30091"))

# datacategoryid
ncdc_stations(datacategoryid="ANNPRCP")
ncdc_stations(datacategoryid="AUAGR")
ncdc_stations(datacategoryid=c("ANNPRCP", "AUAGR"))

# Displays all stations within GHCN-Daily (Displaying page 10 of the results)
ncdc_stations(datasetid='GHCND')

# Specify datasetid and locationid
ncdc_stations(datasetid='GHCND', locationid='FIPS:12017')

# Specify datasetid, locationid, and station
ncdc_stations(datasetid='GHCND', locationid='FIPS:12017', stationid='GHCND:USC00084289')

# Specify datasetid, locationidtype, locationid, and station
ncdc_stations(datasetid='GHCND', locationid='FIPS:12017', stationid='GHCND:USC00084289')

# Displays list of stations within the specified county
ncdc_stations(datasetid='GHCND', locationid='FIPS:12017')

# Displays list of Hourly Precipitation locationids between 01/01/1990 and 12/31/1990
ncdc_stations(datasetid='PRECIP_HLY', startdate='19900101', enddate='19901231')

# Search for stations by spatial extent
## Search using a bounding box, w/ lat/long of the SW corner, then of NE corner
ncdc_stations(extent=c(47.5204,-122.2047,47.6139,-122.1065))
}
}
\references{
\url{https://www.ncdc.noaa.gov/cdo-web/webservices/v2}
}
\seealso{
Other ncdc: \code{\link{ncdc_combine}},
  \code{\link{ncdc_datacats}}, \code{\link{ncdc_datasets}},
  \code{\link{ncdc_datatypes}},
  \code{\link{ncdc_locs_cats}}, \code{\link{ncdc_locs}},
  \code{\link{ncdc_plot}}, \code{\link{ncdc}}
}
\concept{ncdc}
