# from https://www1.ncdc.noaa.gov/pub/data/cdo/documentation/gsom-gsoy_documentation.pdf
ncdc_units_gsom <- list(
  "AWND" = list(name = "AWND", units = "meters_per_sec", description = "Average wind speed"),
  "CDSD" = list(name = "CDSD", units = "celsius", description = "Cooling Degree Days Season to Date"),
  "CLDD" = list(name = "CLDD", units = "celsius", description = "Cooling Degree Days"),
  "DP01" = list(name = "DP01", units = "number_of_days", description = "Number of days with greater than or equal to 0.1 inch of precipitation"),
  "DP05" = list(name = "DP05", units = "number_of_days", description = "Number of days with greater than or equal to 0.5 inch of precipitation"),
  "DP10" = list(name = "DP10", units = "number_of_days", description = "Number of days with greater than or equal to 1.0 inch of precipitation"),
  "DSND" = list(name = "DSND", units = "number_of_days", description = "Number days with snow depth > 1 inch(25.4mm) for the period."),
  "DSNW" = list(name = "DSNW", units = "number_of_days", description = "Number days with snow depth > 1 inch."),
  "DT00" = list(name = "DT00", units = "number_of_days", description = "Number days with minimum temperature less than or equal to 0.0 F"),
  "DT32" = list(name = "DT32", units = "number_of_days", description = "Number days with minimum temperature less than or equal to 32.0 F"),
  "DX32" = list(name = "DX32", units = "number_of_days", description = "Number days with maximum temperature < 32 F."),
  "DX70" = list(name = "DX70", units = "number_of_days", description = "Number days with maximum temperature > 70 F (21.1C)"),
  "DX90" = list(name = "DX90", units = "number_of_days", description = "Number days with maximum temperature > 90 F (32.2C)"),
  "EMNT" = list(name = "EMNT", units = "celsius", description = "Extreme minimum temperature for the period."),
  "EMSD" = list(name = "EMSD", units = "mm", description = "Extreme maximum snow depth for the period."),
  "EMSN" = list(name = "EMSN", units = "mm", description = "Extreme maximum snowfall for the period."),
  "EMXP" = list(name = "EMXP", units = "mm", description = "Extreme maximum precipitation for the period."),
  "EMXT" = list(name = "EMXT", units = "celsius", description = "Extreme maximum temperature for the period."),
  "EVAP" = list(name = "EVAP", units = "mm", description = "Evaporation of water from evaporation pan"),
  "HDSD" = list(name = "HDSD", units = "celsius", description = "Heating Degree Days Season to Date"),
  "HN01" = list(name = "HN01", units = "celsius", description = "Highest minimum soil temperature for the month (degrees F)"),
  "HN02" = list(name = "HN02", units = "celsius", description = "Highest minimum soil temperature for the month (degrees F)"),
  "HN03" = list(name = "HN03", units = "celsius", description = "Highest minimum soil temperature for the month (degrees F)"),
  "HN04" = list(name = "HN04", units = "celsius", description = "Highest minimum soil temperature for the month (degrees F)"),
  "HN05" = list(name = "HN05", units = "celsius", description = "Highest minimum soil temperature for the month (degrees F)"),
  "HN06" = list(name = "HN06", units = "celsius", description = "Highest minimum soil temperature for the month (degrees F)"),
  "HN07" = list(name = "HN07", units = "celsius", description = "Highest minimum soil temperature for the month (degrees F)"),
  "HN08" = list(name = "HN08", units = "celsius", description = "Highest minimum soil temperature for the month (degrees F)"),
  "HTDD" = list(name = "HTDD", units = "celsius", description = "Heating degree days"),
  "HX01" = list(name = "HX01", units = "celsius", description = "Highest maximum soil temperature for the month (degrees F)"),
  "HX02" = list(name = "HX02", units = "celsius", description = "Highest maximum soil temperature for the month (degrees F)"),
  "HX03" = list(name = "HX03", units = "celsius", description = "Highest maximum soil temperature for the month (degrees F)"),
  "HX04" = list(name = "HX04", units = "celsius", description = "Highest maximum soil temperature for the month (degrees F)"),
  "HX05" = list(name = "HX05", units = "celsius", description = "Highest maximum soil temperature for the month (degrees F)"),
  "HX06" = list(name = "HX06", units = "celsius", description = "Highest maximum soil temperature for the month (degrees F)"),
  "HX07" = list(name = "HX07", units = "celsius", description = "Highest maximum soil temperature for the month (degrees F)"),
  "HX08" = list(name = "HX08", units = "celsius", description = "Highest maximum soil temperature for the month (degrees F)"),
  "LN01" = list(name = "LN01", units = "celsius", description = "Lowest minimum soil temperature for the month (degrees F)"),
  "LN02" = list(name = "LN02", units = "celsius", description = "Lowest minimum soil temperature for the month (degrees F)"),
  "LN03" = list(name = "LN03", units = "celsius", description = "Lowest minimum soil temperature for the month (degrees F)"),
  "LN04" = list(name = "LN04", units = "celsius", description = "Lowest minimum soil temperature for the month (degrees F)"),
  "LN05" = list(name = "LN05", units = "celsius", description = "Lowest minimum soil temperature for the month (degrees F)"),
  "LN06" = list(name = "LN06", units = "celsius", description = "Lowest minimum soil temperature for the month (degrees F)"),
  "LN07" = list(name = "LN07", units = "celsius", description = "Lowest minimum soil temperature for the month (degrees F)"),
  "LN08" = list(name = "LN08", units = "celsius", description = "Lowest minimum soil temperature for the month (degrees F)"),
  "LX01" = list(name = "LX01", units = "celsius", description = "Lowest maximum soil temperature for the month (degrees F)"),
  "LX02" = list(name = "LX02", units = "celsius", description = "Lowest maximum soil temperature for the month (degrees F)"),
  "LX03" = list(name = "LX03", units = "celsius", description = "Lowest maximum soil temperature for the month (degrees F)"),
  "LX04" = list(name = "LX04", units = "celsius", description = "Lowest maximum soil temperature for the month (degrees F)"),
  "LX05" = list(name = "LX05", units = "celsius", description = "Lowest maximum soil temperature for the month (degrees F)"),
  "LX06" = list(name = "LX06", units = "celsius", description = "Lowest maximum soil temperature for the month (degrees F)"),
  "LX07" = list(name = "LX07", units = "celsius", description = "Lowest maximum soil temperature for the month (degrees F)"),
  "LX08" = list(name = "LX08", units = "celsius", description = "Lowest maximum soil temperature for the month (degrees F)"),
  "MN01" = list(name = "MN01", units = "celsius", description = "Monthly mean minimum soil temperature (degrees F)"),
  "MN02" = list(name = "MN02", units = "celsius", description = "Monthly mean minimum soil temperature (degrees F)"),
  "MN03" = list(name = "MN03", units = "celsius", description = "Monthly mean minimum soil temperature (degrees F)"),
  "MN04" = list(name = "MN04", units = "celsius", description = "Monthly mean minimum soil temperature (degrees F)"),
  "MN05" = list(name = "MN05", units = "celsius", description = "Monthly mean minimum soil temperature (degrees F)"),
  "MN06" = list(name = "MN06", units = "celsius", description = "Monthly mean minimum soil temperature (degrees F)"),
  "MN07" = list(name = "MN07", units = "celsius", description = "Monthly mean minimum soil temperature (degrees F)"),
  "MN08" = list(name = "MN08", units = "celsius", description = "Monthly mean minimum soil temperature (degrees F)"),
  "MX01" = list(name = "MX01", units = "", description = "Monthly mean maximum soil temperature (degrees F)"),
  "MX02" = list(name = "MX02", units = "", description = "Monthly mean maximum soil temperature (degrees F)"),
  "MX03" = list(name = "MX03", units = "", description = "Monthly mean maximum soil temperature (degrees F)"),
  "MX04" = list(name = "MX04", units = "", description = "Monthly mean maximum soil temperature (degrees F)"),
  "MX05" = list(name = "MX05", units = "", description = "Monthly mean maximum soil temperature (degrees F)"),
  "MX06" = list(name = "MX06", units = "", description = "Monthly mean maximum soil temperature (degrees F)"),
  "MX07" = list(name = "MX07", units = "", description = "Monthly mean maximum soil temperature (degrees F)"),
  "MX08" = list(name = "MX08", units = "", description = "Monthly mean maximum soil temperature (degrees F)"),
  "PRCP" = list(name = "PRCP", units = "mm", description = "Precipitation"),
  "PSUN" = list(name = "PSUN", units = "", description = "Daily percent of possible sunshine for the period"),
  "SNOW" = list(name = "SNOW", units = "mm", description = "Snowfall"),
  "TAVG" = list(name = "TAVG", units = "celsius", description = "Average Temperature."),
  "TMAX" = list(name = "TMAX", units = "celsius", description = "Maximum temperature"),
  "TMIN" = list(name = "TMIN", units = "celsius", description = "Minimum temperature"),
  "TSUN" = list(name = "TSUN", units = "", description = "Total sunshine for the period"),
  "WDF1" = list(name = "WDF1", units = "", description = "Direction of fastest 1-minute wind"),
  "WDF2" = list(name = "WDF2", units = "", description = "Direction of fastest 2-minute wind"),
  "WDF5" = list(name = "WDF5", units = "", description = "Direction of fastest 5-second wind"),
  "WDFG" = list(name = "WDFG", units = "", description = "Direction of peak wind gust"),
  "WDFM" = list(name = "WDFM", units = "", description = "Fastest mile wind direction"),
  "WDMV" = list(name = "WDMV", units = "", description = "Total wind movement"),
  "WSF1" = list(name = "WSF1", units = "", description = "Fastest 1-minute wind speed"),
  "WSF2" = list(name = "WSF2", units = "", description = "Fastest 2-minute wind speed"),
  "WSF5" = list(name = "WSF5", units = "", description = "Fastest 5-second wind speed"),
  "WSFG" = list(name = "WSFG", units = "", description = "Peak gust wind speed"),
  "WSFM" = list(name = "WSFM", units = "", description = "Fastest mile wind speed")
)
