% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/isd_stations.R
\name{isd_stations}
\alias{isd_stations}
\alias{isd_stations_search}
\title{Get NOAA ISD/ISH station data from NOAA FTP server.}
\usage{
isd_stations(refresh = FALSE, path = NULL, ...)

isd_stations_search(lat = NULL, lon = NULL, radius = NULL, bbox = NULL,
  ...)
}
\arguments{
\item{refresh}{(logical) Download station data from NOAA ftp server again. 
Default: \code{FALSE}}

\item{path}{(character) If \code{refresh=TRUE}, this is the path where file is saved.
If \code{refresh=FALSE}, this argument is ignored.}

\item{...}{Curl options passed on to \code{\link[httr]{GET}}}

\item{lat}{(numeric) Latitude, in decimal degree}

\item{lon}{(numeric) Latitude, in decimal degree}

\item{radius}{(numeric) Radius (in km) to search from the lat,lon coordinates}

\item{bbox}{(numeric) Bounding box, of the form: min-longitude, min-latitude, 
max-longitude, max-latitude}
}
\value{
\code{isd_stations} returns a data.frame with the columns:
\itemize{
 \item usaf - USAF number, character
 \item wban - WBAN number, character
 \item station_name - station name, character
 \item ctry - Country, if given, character
 \item state - State, if given, character
 \item icao - ICAO number, if given, character
 \item lat - Latitude, if given, numeric
 \item lon - Longitude, if given, numeric
 \item elev_m - Elevation, if given, numeric
 \item begin - Begin date of data coverage, of form YYYYMMDD, numeric
 \item end - End date of data coverage, of form YYYYMMDD, numeric
}

\code{isd_stations_search} returns a data.frame, if any matches, with the same columns
as listed above
}
\description{
Get NOAA ISD/ISH station data from NOAA FTP server.
}
\details{
\code{\link{isd_stations_search}} requires \pkg{geojsonio} and \pkg{lawn}, 
but are not imported in this package, so they aren't required for the rest of the 
package to operate - only this function. Install those from CRAN if you don't 
already have them.

When using \code{isd_station_search} we clean up the data.frame, removing
stations with no lat/long coordinates, those with impossible lat/long coordinates, 
and those at 0,0.
}
\examples{
\dontrun{
# Get station table
stations <- isd_stations()
head(stations)

## plot stations
### remove incomplete cases, those at 0,0
df <- stations[complete.cases(stations$lat, stations$lon), ]
df <- df[df$lat != 0, ]
### make plot
library("leaflet")
leaflet(data = df) \%>\%
  addTiles() \%>\%
  addCircles()

# Search for stations by various inputs
## bounding box
bbox <- c(-125.0, 38.4, -121.8, 40.9)
(out <- isd_stations_search(bbox = bbox))

## lat, long, radius
isd_stations_search(lat = 38.4, lon = -123, radius = 250)

### then plot...
}
}
\references{
ftp://ftp.ncdc.noaa.gov/pub/data/noaa/
}
\seealso{
\code{\link{isd}}
}

