% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/foldrnaCrosslink.R
\docType{methods}
\name{foldrnaCrosslink}
\alias{foldrnaCrosslink}
\alias{foldrnaCrosslink,rnaCrosslinkDataSet-method}
\title{foldrnaCrosslink}
\usage{
foldrnaCrosslink(
  cdsObject,
  rnaRefs,
  start,
  end,
  evCutoff = 1,
  ensembl = 50,
  constraintNumber = 20,
  shape = 0
)
}
\arguments{
\item{cdsObject}{rnaCrosslinkDataSet object created with rnaCrosslinkDataSet}

\item{rnaRefs}{named List - a list with named elements that correspond to the
.RNA of interest. The element of the list must be a fasta file that has
been read with \code{seqinr::read.fasta()}}

\item{start}{Start of segmnent to fold}

\item{end}{End of segmnent to fold}

\item{evCutoff}{Mininum number of read support for contraint to be included in folding}

\item{ensembl}{Number of structures to Nake}

\item{constraintNumber}{Number of constraints to add to each final fold}

\item{shape}{shape reactivities (0 for no constraints)}
}
\value{
a rnaCrosslinkDataSet object
}
\description{
This methods folds an ensebl of structures for the whole RNA or chosen region
of the RNA. See \code{rnaCrosslinkDataSet} for slot information.
}
\examples{
\dontrun{
cds = makeExamplernaCrosslinkDataSet()

clusteredCds = clusterrnaCrosslink(cds,
                cores = 1,
                stepCount = 1,
                clusterCutoff = 0)
                
trimmedClusters = trimClusters(clusteredCds = clusteredCds,
             trimFactor = 1, 
             clusterCutoff = 0)
             
              

fasta = paste(c(rep('A',25),
                rep('T',25),
                rep('A',10),
                rep('T',23)),collapse = "")

header = '>transcript1'


fastaFile = tempfile()
writeLines(paste(header,fasta,sep = "\n"),con = fastaFile)


rnaRefs = list()
rnaRefs[[rnas(cds)]] = read.fasta(fastaFile)
rnaRefs



foldedCds = foldrnaCrosslink(trimmedClusters,
                         rnaRefs = rnaRefs,
                         start = 1,
                         end = 83,
                         shape = 0,
                         ensembl = 5,
                         constraintNumber  = 1,
                         evCutoff = 1)
foldedCds
}
}
