% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mzQC.R
\name{isValidMzQC}
\alias{isValidMzQC}
\title{Checks validity (= completeness) of mzQC objects - or lists (JSON arrays) thereof}
\usage{
isValidMzQC(x, parent_context = NULL)
}
\arguments{
\item{x}{An mzQC refclass (or list of them), which will be subjected to validation}

\item{parent_context}{Internal parameter used to track the path in nested validations}
}
\description{
Note: Returns TRUE for empty lists!
}
\details{
This function checks if an mzQC object or a list of mzQC objects is valid.
For lists, all elements need to be valid for the function to return TRUE.
The function provides detailed error messages that include the path to the invalid field,
making it easier to identify validation issues in complex nested structures.
}
\examples{
  isValidMzQC(MzQCcvParameter$new("MS:4000059"))       # FALSE
  isValidMzQC(MzQCcvParameter$new("MS:4000059", "Number of MS1 spectra")) # TRUE
  isValidMzQC(list(MzQCcvParameter$new("MS:4000059"))) # FALSE
  isValidMzQC(list(MzQCcvParameter$new("MS:4000059", "Number of MS1 spectra"))) # TRUE

}
