% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/interaction.R
\name{estimate_interaction}
\alias{estimate_interaction}
\title{Estimating interaction effect estimates}
\usage{
estimate_interaction(object, exposure, interaction, conf_level = 0.95, ...)
}
\arguments{
\item{object}{A \code{mdl_tbl} object subset to a single row}

\item{exposure}{The exposure variable in the model}

\item{interaction}{The interaction variable in the model}

\item{conf_level}{The confidence level for the confidence interval}

\item{...}{Arguments to be passed to or from other methods}
}
\value{
A \code{data.frame} with \code{n = levels(interaction)} rows (for the
presence or absence of the interaction term) and \code{n = 5} columns:
\itemize{
\item estimate: beta coefficient for the interaction effect based on level
\item conf_low: lower bound of confidence interval for the estimate
\item conf_high: higher bound of confidence interval for the estimate
\item p_value: p-value for the overall interaction effect \emph{across levels}
\item nobs: number of observations within the interaction level
\item level: level of the interaction term
}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

When using categorical interaction terms in a \code{mdl_tbl} object, estimates
on interaction terms and their confidence intervals can be evaluated. The
effect of interaction on the estimates is based on the levels of interaction
term. The estimates and intervals can be derived through the
\code{estimate_interaction()} function. The approach is based on the method
described by Figueiras et al. (1998).
}
\details{
The \code{estimate_interaction()} requires a \code{mdl_tbl} object that is a
single row in length. Filtering the \code{mdl_tbl} should occur prior to
passing it to this function. Additionally, this function assumes the
interaction term is binary. If it is categorical, the current
recommendation is to use dummy variables for the corresponding levels prior
to modeling.
}
\references{
A. Figueiras, J. M. Domenech-Massons, and Carmen Cadarso, 'Regression models:
calculating the confidence intervals of effects in the presence of
interactions', Statistics in Medicine, 17, 2099-2105 (1998)
}
