% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/html_docco.R
\name{html_docco}
\alias{html_docco}
\title{Convert to an HTML document}
\usage{
html_docco(fig_width = 6, fig_height = 6, fig_caption = TRUE,
  highlight = "pygments", pandoc_args = NULL, ...)
}
\arguments{
\item{fig_width}{Default width (in inches) for figures}

\item{fig_height}{Default width (in inches) for figures}

\item{fig_caption}{\code{TRUE} to render figures with captions}

\item{highlight}{Syntax highlighting style. Supported styles include
"default", "tango", "pygments", "kate", "monochrome", "espresso",
"zenburn", "haddock", and "textmate". Pass \code{NULL} to prevent syntax
highlighting.}

\item{pandoc_args}{arguments passed to the pandoc_args argument of rmarkdown \code{\link{html_document}}}

\item{...}{Additional function arguments passed to rmarkdown \code{\link{html_document}}}
}
\value{
R Markdown output format to pass to \code{\link{render}}
}
\description{
Format for converting from R Markdown to an HTML document.
}
\examples{

\dontrun{
# Simplest example
render("input.Rmd", html_docco())
}

# Runnable example
library(rmdformats)
library(rmarkdown)
rmd_file <- system.file("sample_file/example.Rmd", package="rmdformats")
render(rmd_file, html_docco(), output_dir = tempdir())

}

