/*
 * Decompiled with CFR 0.152.
 */
package weka.experiment;

import java.util.Enumeration;
import java.util.Random;
import java.util.Vector;
import weka.core.AdditionalMeasureProducer;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.RevisionHandler;
import weka.core.RevisionUtils;
import weka.core.Utils;
import weka.experiment.AveragingResultProducer;
import weka.experiment.CSVResultListener;
import weka.experiment.ResultListener;
import weka.experiment.ResultProducer;

public class LearningRateResultProducer
implements ResultListener,
ResultProducer,
OptionHandler,
AdditionalMeasureProducer,
RevisionHandler {
    static final long serialVersionUID = -3841159673490861331L;
    protected Instances m_Instances;
    protected ResultListener m_ResultListener = new CSVResultListener();
    protected ResultProducer m_ResultProducer = new AveragingResultProducer();
    protected String[] m_AdditionalMeasures = null;
    protected int m_LowerSize = 0;
    protected int m_UpperSize = -1;
    protected int m_StepSize = 10;
    protected int m_CurrentSize = 0;
    public static String STEP_FIELD_NAME = "Total_instances";

    public String globalInfo() {
        return "Tells a sub-ResultProducer to reproduce the current run for varying sized subsamples of the dataset. Normally used with an AveragingResultProducer and CrossValidationResultProducer combo to generate learning curve results. For non-numeric result fields, the first value is used.";
    }

    @Override
    public String[] determineColumnConstraints(ResultProducer rp) throws Exception {
        return null;
    }

    @Override
    public void doRunKeys(int run) throws Exception {
        if (this.m_ResultProducer == null) {
            throw new Exception("No ResultProducer set");
        }
        if (this.m_ResultListener == null) {
            throw new Exception("No ResultListener set");
        }
        if (this.m_Instances == null) {
            throw new Exception("No Instances set");
        }
        this.m_ResultProducer.setResultListener(this);
        this.m_ResultProducer.setInstances(this.m_Instances);
        this.m_CurrentSize = this.m_LowerSize == 0 ? this.m_StepSize : this.m_LowerSize;
        while (this.m_CurrentSize <= this.m_Instances.numInstances() && (this.m_UpperSize == -1 || this.m_CurrentSize <= this.m_UpperSize)) {
            this.m_ResultProducer.doRunKeys(run);
            this.m_CurrentSize += this.m_StepSize;
        }
    }

    @Override
    public void doRun(int run) throws Exception {
        if (this.m_ResultProducer == null) {
            throw new Exception("No ResultProducer set");
        }
        if (this.m_ResultListener == null) {
            throw new Exception("No ResultListener set");
        }
        if (this.m_Instances == null) {
            throw new Exception("No Instances set");
        }
        Instances runInstances = new Instances(this.m_Instances);
        runInstances.randomize(new Random(run));
        this.m_ResultProducer.setResultListener(this);
        this.m_CurrentSize = this.m_LowerSize == 0 ? this.m_StepSize : this.m_LowerSize;
        while (this.m_CurrentSize <= this.m_Instances.numInstances() && (this.m_UpperSize == -1 || this.m_CurrentSize <= this.m_UpperSize)) {
            this.m_ResultProducer.setInstances(new Instances(runInstances, 0, this.m_CurrentSize));
            this.m_ResultProducer.doRun(run);
            this.m_CurrentSize += this.m_StepSize;
        }
    }

    @Override
    public void preProcess(ResultProducer rp) throws Exception {
        if (this.m_ResultListener == null) {
            throw new Exception("No ResultListener set");
        }
        this.m_ResultListener.preProcess(this);
    }

    @Override
    public void preProcess() throws Exception {
        if (this.m_ResultProducer == null) {
            throw new Exception("No ResultProducer set");
        }
        this.m_ResultProducer.setResultListener(this);
        this.m_ResultProducer.preProcess();
    }

    @Override
    public void postProcess(ResultProducer rp) throws Exception {
        this.m_ResultListener.postProcess(this);
    }

    @Override
    public void postProcess() throws Exception {
        this.m_ResultProducer.postProcess();
    }

    @Override
    public void acceptResult(ResultProducer rp, Object[] key, Object[] result) throws Exception {
        if (this.m_ResultProducer != rp) {
            throw new Error("Unrecognized ResultProducer sending results!!");
        }
        Object[] newKey = new Object[key.length + 1];
        System.arraycopy(key, 0, newKey, 0, key.length);
        newKey[key.length] = new String("" + this.m_CurrentSize);
        this.m_ResultListener.acceptResult(this, newKey, result);
    }

    @Override
    public boolean isResultRequired(ResultProducer rp, Object[] key) throws Exception {
        if (this.m_ResultProducer != rp) {
            throw new Error("Unrecognized ResultProducer sending results!!");
        }
        Object[] newKey = new Object[key.length + 1];
        System.arraycopy(key, 0, newKey, 0, key.length);
        newKey[key.length] = new String("" + this.m_CurrentSize);
        return this.m_ResultListener.isResultRequired(this, newKey);
    }

    @Override
    public String[] getKeyNames() throws Exception {
        String[] keyNames = this.m_ResultProducer.getKeyNames();
        String[] newKeyNames = new String[keyNames.length + 1];
        System.arraycopy(keyNames, 0, newKeyNames, 0, keyNames.length);
        newKeyNames[keyNames.length] = STEP_FIELD_NAME;
        return newKeyNames;
    }

    @Override
    public Object[] getKeyTypes() throws Exception {
        Object[] keyTypes = this.m_ResultProducer.getKeyTypes();
        Object[] newKeyTypes = new Object[keyTypes.length + 1];
        System.arraycopy(keyTypes, 0, newKeyTypes, 0, keyTypes.length);
        newKeyTypes[keyTypes.length] = "";
        return newKeyTypes;
    }

    @Override
    public String[] getResultNames() throws Exception {
        return this.m_ResultProducer.getResultNames();
    }

    @Override
    public Object[] getResultTypes() throws Exception {
        return this.m_ResultProducer.getResultTypes();
    }

    @Override
    public String getCompatibilityState() {
        String result = " ";
        if (this.m_ResultProducer == null) {
            result = String.valueOf(result) + "<null ResultProducer>";
        } else {
            result = String.valueOf(result) + "-W " + this.m_ResultProducer.getClass().getName();
            result = String.valueOf(result) + " -- " + this.m_ResultProducer.getCompatibilityState();
        }
        return result.trim();
    }

    @Override
    public Enumeration listOptions() {
        Vector<Option> newVector = new Vector<Option>(2);
        newVector.addElement(new Option("\tThe number of steps in the learning rate curve.\n\t(default 10)", "X", 1, "-X <num steps>"));
        newVector.addElement(new Option("\tThe full class name of a ResultProducer.\n\teg: weka.experiment.CrossValidationResultProducer", "W", 1, "-W <class name>"));
        if (this.m_ResultProducer != null && this.m_ResultProducer instanceof OptionHandler) {
            newVector.addElement(new Option("", "", 0, "\nOptions specific to result producer " + this.m_ResultProducer.getClass().getName() + ":"));
            Enumeration enu = ((OptionHandler)((Object)this.m_ResultProducer)).listOptions();
            while (enu.hasMoreElements()) {
                newVector.addElement((Option)enu.nextElement());
            }
        }
        return newVector.elements();
    }

    @Override
    public void setOptions(String[] options) throws Exception {
        String stepSize = Utils.getOption('S', options);
        if (stepSize.length() != 0) {
            this.setStepSize(Integer.parseInt(stepSize));
        } else {
            this.setStepSize(10);
        }
        String lowerSize = Utils.getOption('L', options);
        if (lowerSize.length() != 0) {
            this.setLowerSize(Integer.parseInt(lowerSize));
        } else {
            this.setLowerSize(0);
        }
        String upperSize = Utils.getOption('U', options);
        if (upperSize.length() != 0) {
            this.setUpperSize(Integer.parseInt(upperSize));
        } else {
            this.setUpperSize(-1);
        }
        String rpName = Utils.getOption('W', options);
        if (rpName.length() == 0) {
            throw new Exception("A ResultProducer must be specified with the -W option.");
        }
        this.setResultProducer((ResultProducer)Utils.forName(ResultProducer.class, rpName, null));
        if (this.getResultProducer() instanceof OptionHandler) {
            ((OptionHandler)((Object)this.getResultProducer())).setOptions(Utils.partitionOptions(options));
        }
    }

    @Override
    public String[] getOptions() {
        String[] seOptions = new String[]{};
        if (this.m_ResultProducer != null && this.m_ResultProducer instanceof OptionHandler) {
            seOptions = ((OptionHandler)((Object)this.m_ResultProducer)).getOptions();
        }
        String[] options = new String[seOptions.length + 9];
        int current = 0;
        options[current++] = "-S";
        options[current++] = "" + this.getStepSize();
        options[current++] = "-L";
        options[current++] = "" + this.getLowerSize();
        options[current++] = "-U";
        options[current++] = "" + this.getUpperSize();
        if (this.getResultProducer() != null) {
            options[current++] = "-W";
            options[current++] = this.getResultProducer().getClass().getName();
        }
        options[current++] = "--";
        System.arraycopy(seOptions, 0, options, current, seOptions.length);
        current += seOptions.length;
        while (current < options.length) {
            options[current++] = "";
        }
        return options;
    }

    @Override
    public void setAdditionalMeasures(String[] additionalMeasures) {
        this.m_AdditionalMeasures = additionalMeasures;
        if (this.m_ResultProducer != null) {
            System.err.println("LearningRateResultProducer: setting additional measures for ResultProducer");
            this.m_ResultProducer.setAdditionalMeasures(this.m_AdditionalMeasures);
        }
    }

    @Override
    public Enumeration enumerateMeasures() {
        Vector<String> newVector = new Vector<String>();
        if (this.m_ResultProducer instanceof AdditionalMeasureProducer) {
            Enumeration en = ((AdditionalMeasureProducer)((Object)this.m_ResultProducer)).enumerateMeasures();
            while (en.hasMoreElements()) {
                String mname = (String)en.nextElement();
                newVector.addElement(mname);
            }
        }
        return newVector.elements();
    }

    @Override
    public double getMeasure(String additionalMeasureName) {
        if (this.m_ResultProducer instanceof AdditionalMeasureProducer) {
            return ((AdditionalMeasureProducer)((Object)this.m_ResultProducer)).getMeasure(additionalMeasureName);
        }
        throw new IllegalArgumentException("LearningRateResultProducer: Can't return value for : " + additionalMeasureName + ". " + this.m_ResultProducer.getClass().getName() + " " + "is not an AdditionalMeasureProducer");
    }

    @Override
    public void setInstances(Instances instances) {
        this.m_Instances = instances;
    }

    public String lowerSizeTipText() {
        return "Set the minmum number of instances in a dataset. Setting zero here will actually use <stepSize> number of instances at the first step (since it makes no sense to use zero instances :-))";
    }

    public int getLowerSize() {
        return this.m_LowerSize;
    }

    public void setLowerSize(int newLowerSize) {
        this.m_LowerSize = newLowerSize;
    }

    public String upperSizeTipText() {
        return "Set the maximum number of instances in a dataset. Setting -1 sets no upper limit (other than the total number of instances in the full dataset)";
    }

    public int getUpperSize() {
        return this.m_UpperSize;
    }

    public void setUpperSize(int newUpperSize) {
        this.m_UpperSize = newUpperSize;
    }

    public String stepSizeTipText() {
        return "Set the number of instances to add at each step.";
    }

    public int getStepSize() {
        return this.m_StepSize;
    }

    public void setStepSize(int newStepSize) {
        this.m_StepSize = newStepSize;
    }

    @Override
    public void setResultListener(ResultListener listener) {
        this.m_ResultListener = listener;
    }

    public String resultProducerTipText() {
        return "Set the resultProducer for which learning rate results should be generated.";
    }

    public ResultProducer getResultProducer() {
        return this.m_ResultProducer;
    }

    public void setResultProducer(ResultProducer newResultProducer) {
        this.m_ResultProducer = newResultProducer;
        this.m_ResultProducer.setResultListener(this);
    }

    public String toString() {
        String result = "LearningRateResultProducer: ";
        result = String.valueOf(result) + this.getCompatibilityState();
        result = this.m_Instances == null ? String.valueOf(result) + ": <null Instances>" : String.valueOf(result) + ": " + Utils.backQuoteChars(this.m_Instances.relationName());
        return result;
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 6425 $");
    }
}

