% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rmarkdown-package.R
\docType{package}
\name{rmarkdown-package}
\alias{rmarkdown-package}
\alias{rmarkdown}
\title{R Markdown Document Conversion}
\description{
Convert R Markdown documents into a variety of formats including HTML,
MS Word, PDF, and Beamer.
}
\details{
The \pkg{rmarkdown} package includes high level functions for
  converting to a variety of formats. For example:
  \preformatted{
render("input.Rmd", html_document())
render("input.Rmd", pdf_document())
}
  You can also specify a plain markdown file in which case knitting will be
  bypassed:
  \preformatted{render("input.md", html_document())}
  Additional options can be specified along with the output format:
  \preformatted{render("input.Rmd", html_document(toc = TRUE))
render("input.Rmd", pdf_document(latex_engine = "lualatex"))
render("input.Rmd", beamer_presentation(incremental = TRUE))
}
  You can also include arbitrary pandoc command line arguments along with the
  other options:
  \preformatted{
render("input.Rmd", pdf_document(toc = TRUE, pandoc_args = "--listings"))
}
}
\seealso{
\link{render}, \link{html_document}, \link{pdf_document},
  \link{word_document}, \link{beamer_presentation}
}
