% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lines.R
\name{ms_lines}
\alias{ms_lines}
\title{Convert polygons to topological boundaries (lines)}
\usage{
ms_lines(input, fields = NULL, ...)
}
\arguments{
\item{input}{input polygons object to convert to inner lines. One of:
\itemize{
\item \code{geo_json} or \code{character} polygons;
\item \code{SpatialPolygons*};
\item \code{sf} or \code{sfc} polygons object
}}

\item{fields}{character vector of field names. If left as \code{NULL}
(default), external (unshared) boundaries are attributed as TYPE 0 and
internal (shared) boundaries are TYPE 1. Giving a field name adds an
intermediate level of hierarchy at TYPE 1, with the lowest-level internal
boundaries set to TYPE 2. Supplying a character vector of field names adds
additional levels of hierarchy.}

\item{...}{
  Arguments passed on to \code{\link[=apply_mapshaper_commands]{apply_mapshaper_commands}}
  \describe{
    \item{\code{force_FC}}{should the output be forced to be a FeatureCollection (or sf object or
Spatial*DataFrame) even if there are no attributes? Default \code{TRUE}. If FALSE and
there are no attributes associated with the geometries, a
GeometryCollection (or Spatial object with no dataframe, or sfc) will be output.}
    \item{\code{sys}}{Should the system mapshaper be used instead of the bundled mapshaper? Gives
better performance on large files. Requires the mapshaper node package to be installed
and on the PATH.}
    \item{\code{sys_mem}}{How much memory (in GB) should be allocated if using the system
mapshaper (\code{sys = TRUE})? Default 8. Ignored if \code{sys = FALSE}.
This can also be set globally with the option \code{"mapshaper.sys_mem"}}
    \item{\code{quiet}}{If \code{sys = TRUE}, should the mapshaper messages be silenced? Default \code{FALSE}.
This can also be set globally with the option \code{"mapshaper.sys_quiet"}}
  }}
}
\value{
topological boundaries as lines, in the same class as the input
}
\description{
Convert polygons to topological boundaries (lines)
}
\examples{

library(geojsonsf)
library(sf)

poly <- structure('{"type":"FeatureCollection",
             "features":[
             {"type":"Feature",
             "properties":{"foo": "a"},
             "geometry":{"type":"Polygon","coordinates":[[
             [102,2],[102,3],[103,3],[103,2],[102,2]
             ]]}}
             ,{"type":"Feature",
             "properties":{"foo": "a"},
             "geometry":{"type":"Polygon","coordinates":[[
             [103,3],[104,3],[104,2],[103,2],[103,3]
             ]]}},
             {"type":"Feature",
             "properties":{"foo": "b"},
             "geometry":{"type":"Polygon","coordinates":[[
             [102.5,1],[102.5,2],[103.5,2],[103.5,1],[102.5,1]
             ]]}}]}', class = c("geojson", "json"))

poly <- geojson_sf(poly)
summary(poly)
plot(poly)

out <- ms_lines(poly)
summary(out)
plot(out)

}
