% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/subsetObject.R
\name{subsetLiger}
\alias{subsetLiger}
\title{Subset liger object}
\usage{
subsetLiger(
  object,
  featureIdx = NULL,
  cellIdx = NULL,
  useSlot = NULL,
  chunkSize = 1000,
  verbose = getOption("ligerVerbose", TRUE),
  newH5 = TRUE,
  returnObject = TRUE,
  ...
)
}
\arguments{
\item{object}{A \linkS4class{liger} or \linkS4class{ligerDataset} object.}

\item{featureIdx}{Character vector. Missing or \code{NULL} for all
features.}

\item{cellIdx}{Character, logical or numeric index that can subscribe cells.
Missing or \code{NULL} for all cells.}

\item{useSlot}{The slot(s) to only consider. Choose one or more from
\code{"rawData"}, \code{"normData"} and \code{"scaleData"}. Default
\code{NULL} subsets the whole object including analysis result matrices.}

\item{chunkSize}{Integer. Number of maximum number of cells in each chunk,
Default \code{1000}.}

\item{verbose}{Logical. Whether to show information of the progress. Default
\code{getOption("ligerVerbose")} or \code{TRUE} if users have not set.}

\item{newH5}{Whether to create new H5 files on disk for the subset datasets
if involved datasets in the \code{object} is HDF5 based. \code{TRUE} writes a
new ones, \code{FALSE} returns in memory data.}

\item{returnObject}{Logical, whether to return a \linkS4class{liger} object
for result. Default \code{TRUE}. \code{FALSE} returns a list containing
requested values.}

\item{...}{Arguments passed to \code{subsetLigerDataset}}
}
\value{
Subset \code{object}
}
\description{
This function subsets a \linkS4class{liger} object with
character feature index and any valid cell index. For datasets based on HDF5,
the filenames of subset H5 files could only be automatically generated for
now. Feature subsetting is based on the intersection of available features
from datasets involved by \code{cellIdx}, while \code{featureIdx = NULL} does
not take the intersection (i.e. nothing done on the feature axis).

a \linkS4class{ligerDataset} object is also allowed for now and meanwhile,
setting \code{filename} is supported.
}
\examples{
pbmc.small <- subsetLiger(pbmc, cellIdx = pbmc$nUMI > 200)
pbmc.small <- pbmc[, pbmc$nGene > 50]
}
\seealso{
\code{\link{subsetLigerDataset}}
}
