% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/import.R
\name{createLiger}
\alias{createLiger}
\title{Create liger object}
\usage{
createLiger(
  rawData,
  modal = NULL,
  cellMeta = NULL,
  removeMissing = TRUE,
  addPrefix = "auto",
  formatType = "10X",
  anndataX = "X",
  dataName = NULL,
  indicesName = NULL,
  indptrName = NULL,
  genesName = NULL,
  barcodesName = NULL,
  newH5 = TRUE,
  verbose = getOption("ligerVerbose", TRUE),
  ...,
  remove.missing = removeMissing,
  format.type = formatType,
  data.name = dataName,
  indices.name = indicesName,
  indptr.name = indptrName,
  genes.name = genesName,
  barcodes.name = barcodesName
)
}
\arguments{
\item{rawData}{Named list of datasets. Required. Elements allowed include a
matrix, a \code{Seurat} object, a \code{SingleCellExperiment} object, an
\code{AnnData} object, a \linkS4class{ligerDataset} object or a filename to
an HDF5 file. See detail for HDF5 reading.}

\item{modal}{Character vector for modality setting. Use one string for all
datasets, or the same number of strings as the number of datasets. Currently
options of \code{"default"}, \code{"rna"}, \code{"atac"}, \code{"spatial"}
and \code{"meth"} are supported.}

\item{cellMeta}{data.frame of metadata at single-cell level. Default
\code{NULL}.}

\item{removeMissing}{Logical. Whether to remove cells that do not have any
counts and features not expressed in any cells from each dataset. Default
\code{TRUE}.}

\item{addPrefix}{Logical. Whether to add "<dataset name>_" as a prefix of
cell identifiers (e.g. barcodes) to avoid duplicates in multiple libraries (
common with 10X data). Default \code{"auto"} detects if matrix columns
already has the exact prefix or not. Logical value forces the action.}

\item{formatType}{Select preset of H5 file structure. Current available
options are \code{"10X"} and \code{"AnnData"}. Can be either a single
specification for all datasets or a character vector that match with each
dataset.}

\item{anndataX}{The HDF5 path to the raw count data in an H5AD file. See
\code{\link{createH5LigerDataset}} Details. Default \code{"X"}.}

\item{dataName, indicesName, indptrName}{The path in a H5 file for the raw
sparse matrix data. These three types of data stands for the \code{x},
\code{i}, and \code{p} slots of a \code{\link[Matrix]{dgCMatrix-class}}
object. Default \code{NULL} uses \code{formatType} preset.}

\item{genesName, barcodesName}{The path in a H5 file for the gene names and
cell barcodes. Default \code{NULL} uses \code{formatType} preset.}

\item{newH5}{When using HDF5 based data and subsets created after removing
missing cells/features, whether to create new HDF5 files for the subset.
Default \code{TRUE}. If \code{FALSE}, data will be subset into memory and
can be dangerous for large scale analysis.}

\item{verbose}{Logical. Whether to show information of the progress. Default
\code{getOption("ligerVerbose")} or \code{TRUE} if users have not set.}

\item{...}{Additional slot values that should be directly placed in object.}

\item{remove.missing, format.type, data.name, indices.name, indptr.name, genes.name, barcodes.name}{\bold{Deprecated.} See Usage section for replacement.}
}
\description{
This function allows creating \linkS4class{liger} object from
multiple datasets of various forms (See \code{rawData}).
}
\examples{
# Create from raw count matrices
ctrl.raw <- rawData(pbmc, "ctrl")
stim.raw <- rawData(pbmc, "stim")
pbmc1 <- createLiger(list(ctrl = ctrl.raw, stim = stim.raw))

# Create from H5 files
h5Path <- system.file("extdata/ctrl.h5", package = "rliger")
print(h5Path)
lig <- createLiger(list(ctrl = h5Path))

# Create from other container object
ctrl.seu <- SeuratObject::CreateSeuratObject(ctrl.raw)
stim.seu <- SeuratObject::CreateSeuratObject(stim.raw)
pbmc2 <- createLiger(list(ctrl = ctrl.seu, stim = stim.seu))
}
\seealso{
\code{\link{createLigerDataset}}, \code{\link{createH5LigerDataset}}
}
