% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/covariance_matrix.R
\name{U_ghuv}
\alias{U_ghuv}
\title{A dependence structure of 2 random variables.}
\usage{
U_ghuv(alpha, sigma, g, h, u, v, ...)
}
\arguments{
\item{alpha}{self-similarity parameter of alpha stable random motion.}

\item{sigma}{Scale parameter of lfsm}

\item{g, h}{functions \eqn{g,h: \R to \R} with finite alpha-norm (see \code{\link{Norm_alpha}}).}

\item{v, u}{real numbers}

\item{...}{additional parameters to pass to U_gh and U_g}
}
\description{
It is used when random variables do not have finite second moments, and thus, the covariance matrix is not defined.
For \eqn{X= \int_{\R} g_s dL_s} and \eqn{Y= \int_{\R} h_s dL_s} with \eqn{\| g \|_{\alpha}, \| h\|_{\alpha}< \infty}. Then the measure of dependence is given by \eqn{U_{g,h}: \R^2 to \R} via
\deqn{U_{g,h} (u,v)=\exp(- \sigma^{\alpha}{\| ug +vh \|_{\alpha}}^{\alpha} ) - \exp(- \sigma^{\alpha} ({\| ug \|_{\alpha}}^{\alpha} + {\| vh \|_{\alpha}}^{\alpha}))}
}
\examples{
g<-function(x) exp(-x^2)
h<-function(x) exp(-abs(x))
U_ghuv(alpha=1.5, sigma=1, g=g, h=h, u=10, v=15,
rel.tol = .Machine$double.eps^0.25, abs.tol=1e-11)
}
