% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/maxmatching.R
\name{MaxCardinalityMatching}
\alias{MaxCardinalityMatching}
\title{Solve for Maximum Cardinality Matching}
\usage{
MaxCardinalityMatching(
  arcSources,
  arcTargets,
  numNodes,
  algorithm = "MaxMatching"
)
}
\arguments{
\item{arcSources}{Vector corresponding to the source nodes of a graph's
edges}

\item{arcTargets}{Vector corresponding to the destination nodes of a graph's
edges}

\item{numNodes}{The number of nodes in the graph}

\item{algorithm}{Choices of algorithm include "MaxMatching" and
"MaxFractionalMatching". "MaxMatching" is the default.}
}
\value{
A list containing two entries: 1) The matching value, 2) The edges
  of the final graph, in a List of (node, node) pairs
}
\description{
Finds the maximum cardinality matching in graphs and bipartite graphs.
}
\details{
For details on LEMON's implementation, including differences between the
algorithms, see \url{https://lemon.cs.elte.hu/pub/doc/1.3.1/a00615.html}.
}
