% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parse.R
\name{parse_expr}
\alias{parse_expr}
\alias{parse_exprs}
\title{Parse R code}
\usage{
parse_expr(x)

parse_exprs(x)
}
\arguments{
\item{x}{Text containing expressions to parse_expr for
\code{parse_expr()} and \code{parse_exprs()}. Can also be an R connection,
for instance to a file. If the supplied connection is not open,
it will be automatically closed and destroyed.}
}
\value{
\code{parse_expr()} returns an \link[=is_expression]{expression},
\code{parse_exprs()} returns a list of expressions. Note that for the
plural variants the length of the output may be greater than the
length of the input. This would happen is one of the strings
contain several expressions (such as \code{"foo; bar"}). The names of
\code{x} are preserved (and recycled in case of multiple expressions).
}
\description{
These functions parse and transform text into R expressions. This
is the first step to interpret or evaluate a piece of R code
written by a programmer.
}
\details{
\code{parse_expr()} returns one expression. If the text contains more
than one expression (separated by semicolons or new lines), an error is
issued. On the other hand \code{parse_exprs()} can handle multiple
expressions. It always returns a list of expressions (compare to
\code{\link[base:parse]{base::parse()}} which returns a base::expression vector). All
functions also support R connections.
}
\examples{
# parse_expr() can parse any R expression:
parse_expr("mtcars \%>\% dplyr::mutate(cyl_prime = cyl / sd(cyl))")

# A string can contain several expressions separated by ; or \n
parse_exprs("NULL; list()\n foo(bar)")

# Use names to figure out which input produced an expression:
parse_exprs(c(foo = "1; 2", bar = "3"))

# You can also parse source files by passing a R connection. Let's
# create a file containing R code:
path <- tempfile("my-file.R")
cat("1; 2; mtcars", file = path)

# We can now parse it by supplying a connection:
parse_exprs(file(path))
}
\seealso{
\code{\link[base:parse]{base::parse()}}
}
