% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/expr.R
\name{expr}
\alias{expr}
\alias{enexpr}
\alias{exprs}
\title{Raw quotation of an expression}
\usage{
expr(expr)

enexpr(arg)

exprs(..., .ignore_empty = "trailing")
}
\arguments{
\item{expr}{An expression.}

\item{arg}{A symbol referring to an argument. The expression
supplied to that argument will be captured unevaluated.}

\item{...}{Arguments to extract.}

\item{.ignore_empty}{Whether to ignore empty arguments. Can be one
of \code{"trailing"}, \code{"none"}, \code{"all"}. If \code{"trailing"}, only the
last argument is ignored if it is empty.}
}
\value{
The raw expression supplied as argument. \code{exprs()} returns
a list of expressions.
}
\description{
These functions return raw expressions (whereas \code{\link[=quo]{quo()}} and
variants return quosures). They support \link{quasiquotation}
syntax.
\itemize{
\item \code{expr()} returns its argument unevaluated. It is equivalent to
\code{\link[base:bquote]{base::bquote()}}.
\item \code{enexpr()} takes an argument name and returns it unevaluated. It
is equivalent to \code{\link[base:substitute]{base::substitute()}}.
\item \code{exprs()} captures multiple expressions and returns a list. In
particular, it can capture expressions in \code{...}. It supports name
unquoting with \code{:=} (see \code{\link[=quos]{quos()}}). It is equivalent to
\code{eval(substitute(alist(...)))}.
}

See \code{\link[=is_expr]{is_expr()}} for more about R expressions.
}
\examples{
# The advantage of expr() over quote() is that it unquotes on
# capture:
expr(list(1, !! 3 + 10))

# Unquoting can be especially useful for successive transformation
# of a captured expression:
(expr <- quote(foo(bar)))
(expr <- expr(inner(!! expr, arg1)))
(expr <- expr(outer(!! expr, !!! lapply(letters[1:3], as.symbol))))

# Unlike quo(), expr() produces expressions that can
# be evaluated with base::eval():
e <- quote(letters)
e <- expr(toupper(!!e))
eval(e)

# Be careful if you unquote a quosure: you need to take the RHS
# (and lose the scope information) to evaluate with eval():
f <- quo(letters)
e <- expr(toupper(!! get_expr(f)))
eval(e)

# On the other hand it's fine to unquote quosures if you evaluate
# with eval_tidy():
f <- quo(letters)
e <- expr(toupper(!! f))
eval_tidy(e)

# exprs() lets you unquote names with the definition operator:
nm <- "foo"
exprs(a = 1, !! nm := 2)
}
\seealso{
\code{\link[=quo]{quo()}}, \code{\link[=is_expr]{is_expr()}}
}
