% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/apps_of_direction.R
\name{riverdirectionmatbysurvey}
\alias{riverdirectionmatbysurvey}
\title{River Direction Matrix of All Observations of an Individual}
\usage{
riverdirectionmatbysurvey(indiv, unique, survey, seg, vert, rivers,
  full = TRUE, flowconnected = FALSE, stopiferror = TRUE,
  algorithm = NULL)
}
\arguments{
\item{indiv}{The unique identifier of the fish in question.}

\item{unique}{A vector of identifiers for each fish.}

\item{survey}{A vector of identifiers for each survey.  It is recommended to
use a numeric or date format (see \link{as.Date}) to preserve survey order.}

\item{seg}{A vector of river locations (segment component).}

\item{vert}{A vector of river locations (vertex component).}

\item{rivers}{The river network object to use.}

\item{full}{Whether to return the full matrix, with \code{NA} values for
missing data (\code{TRUE}), or a the subset of rows and columns
corresponding to successful observations.  Defaults to \code{TRUE}.}

\item{flowconnected}{If \code{TRUE}, only returns direction if the input segments are flow-connected.  Defaults to \code{FALSE}.}

\item{stopiferror}{Whether or not to exit with an error if a route cannot be
found.  If this is set to \code{FALSE} and a route cannot be found, the
function will return \code{NA} in the appropriate entry.  Defaults to
\code{TRUE}.  See \link{detectroute}.}

\item{algorithm}{Which route detection algorithm to use (\code{"Dijkstra"},
\code{"sequential"}, or \code{"segroutes"}).  If left as \code{NULL} (the
default), the function will automatically make a selection.  See
\link{detectroute} for more details.}
}
\value{
A matrix of directions (character), with rows and columns defined by
  survey.  In the resulting matrix, the element with the row identified as
  \code{A} and column identified as \code{B} is defined as the direction
  traveled from survey A to survey B.  Therefore, it is likely that only the
  upper triangle of the matrix will be of interest.
}
\description{
Returns a matrix of travel direction between all observations of
  one unique fish.
}
\note{
Building routes from the river mouth to each river network segment may
  greatly reduce computation time (see \link{buildsegroutes}).
}
\examples{
data(Gulk, fakefish)
riverdirectionmatbysurvey(indiv=1, unique=fakefish$fish.id, survey=fakefish$flight,
      seg=fakefish$seg, vert=fakefish$vert, rivers=Gulk)
     
riverdirectionmatbysurvey(indiv=1, unique=fakefish$fish.id, survey=fakefish$flight,
      seg=fakefish$seg, vert=fakefish$vert, rivers=Gulk, full=FALSE)
}
\author{
Matt Tyers
}
\seealso{
\link{riverdirection}
}

