% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/riverdist_1.R
\name{pointshp2segvert}
\alias{pointshp2segvert}
\title{Convert a Point Shapefile to River Locations}
\usage{
pointshp2segvert(path = ".", layer, rivers)
}
\arguments{
\item{path}{File path, default is the current working directory.}

\item{layer}{Name of the shapefile, without the .shp extension.}

\item{rivers}{The river network object to use.}
}
\value{
A data frame of river locations, with segment numbers in
  \code{$seg}, vertex numbers in \code{$vert}, snapping distances in \code{$snapdist}, and the remaining columns
  corresponding to the data table in the input point shapefile.
}
\description{
This function reads a point shapefile and determines the closest
  vertex in the river network to each point of XY data, returning a data
  frame with river locations, defined as segment numbers and vertex
  numbers, along with the data table read from the input shapefile.
}
\note{
If the input shapefile is detected to be in a different projection than
  the river network, the input shapefile will be re-projected before
  conversion to river locations.
}
\examples{
filepath <- system.file("extdata", package="riverdist")

fakefish_UTM5 <- pointshp2segvert(path=filepath, layer="fakefish_UTM5", rivers=Gulk)
head(fakefish_UTM5)

plot(x=Gulk)
points(fakefish_UTM5$x, fakefish_UTM5$y)
riverpoints(seg=fakefish_UTM5$seg, vert=fakefish_UTM5$vert, rivers=Gulk, pch=16, col=2)

}
\author{
Matt Tyers
}

