% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shortestroute_cleanup.R
\name{connectsegs}
\alias{connectsegs}
\title{Connect Segments}
\usage{
connectsegs(connect, connectto, nearestvert = F, rivers)
}
\arguments{
\item{connect}{The segment to connect to the network.  Typically, this is the
segment that is disconnected from the rest of the river network.}

\item{connectto}{The segment to connect it to.  Typically, this is a segment
that is connected to the rest of the river network.}

\item{nearestvert}{Whether to connect at the nearest vertex and split the
segment (\code{FALSE}), or connect at the nearest endpoint (\code{TRUE}). 
Defaults to \code{TRUE}.}

\item{rivers}{The river network object to use.}
}
\value{
A new river network object with the specified segments connected (see
  \link{rivernetwork})
}
\description{
Provides a method to manually connect unconnected segments
  within a river network.  The nearest endpoint (or vertex) of the second segment is
  added as a new vertex to the first, and the network topology is then updated.
}
\note{
This function is called within \link{cleanup}, which is recommended in
  most cases.
}
\examples{
data(Koyukuk0)
plot(Koyukuk0, ylim=c(1930500,1931500), xlim=c(194900,195100))
topologydots(Koyukuk0, add=TRUE)

Koyukuk0.1 <- connectsegs(connect=21, connectto=20, rivers=Koyukuk0)
plot(Koyukuk0.1,ylim=c(1930500,1931500), xlim=c(194900,195100))
topologydots(Koyukuk0.1, add=TRUE)
}
\author{
Matt Tyers
}
\seealso{
line2network
}

