% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/detectbraiding.R
\name{checkbraidedTF}
\alias{checkbraidedTF}
\title{Check for Braiding in a River Network}
\usage{
checkbraidedTF(rivers, toreturn = "rivers")
}
\arguments{
\item{rivers}{The river network object to check.}

\item{toreturn}{Specifying \code{toreturn="rivers"} (the default) will return a river network object with a value of \code{TRUE} or \code{FALSE} assigned to the \code{$braided} element of the river network object.  Specifying \code{toreturn="logical"} will just return \code{TRUE} if braiding is detected or \code{FALSE} if no braiding is detected.}
}
\description{
Detects braiding (multiple flow channels between two locations)
  within a river network object, and returns a logical value for specifying braiding within a river network object.
}
\note{
This function is called within \link{cleanup}, which is recommended in most cases.
}
\examples{
data(Gulk,KilleyW)
Gulk <- setmouth(seg=1, vert=1, rivers=Gulk)
plot(x=Gulk)
checkbraidedTF(rivers=Gulk, toreturn="logical")

KilleyW <- setmouth(seg=1, vert=288, rivers=KilleyW)
plot(x=KilleyW)
checkbraidedTF(rivers=KilleyW, toreturn="logical")

KilleyW.1 <- checkbraidedTF(rivers=KilleyW, toreturn="rivers")
str(KilleyW.1)
}
\author{
Matt Tyers
}

