% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/italic_taxonomy.R
\name{italic_taxonomy}
\alias{italic_taxonomy}
\title{Get taxonomic classification of lichen taxa}
\usage{
italic_taxonomy(sp_names)
}
\arguments{
\item{sp_names}{Character vector of accepted names}
}
\value{
A data frame with:
\describe{
\item{scientific_name}{Scientific name}
\item{phylum}{Phylum}
\item{class}{Class}
\item{order}{Order}
\item{family}{Family}
\item{genus}{Genus}
}
}
\description{
Retrieves the complete taxonomic hierarchy for lichen taxa from the ITALIC database.
Only accepts names that exist in the database of ITALIC.
}
\note{
Before using this function with a list of names, first obtain their accepted names
using \code{italic_match()}.
Example workflow:
names_matched <- italic_match(your_names)
taxonomy <- italic_taxonomy(names_matched$accepted_name)
}
\examples{
\dontrun{
taxonomy <- italic_taxonomy("Cetraria islandica (L.) Ach. subsp. islandica")
}

}
