% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/comp_util.R
\name{is_perc}
\alias{is_perc}
\title{Verify that input is a percentage (numeric value from 0 to 100).}
\usage{
is_perc(perc)
}
\arguments{
\item{perc}{A single (typically numeric) argument.}
}
\value{
A Boolean value:
\code{TRUE} if \code{perc} is a percentage (proportion),
otherwise \code{FALSE}.
}
\description{
\code{is_perc} is a function that checks whether its single argument \code{perc}
is a percentage (proportion, i.e., a numeric value in the range from 0 to 100).
}
\examples{
# ways to succeed:
is_perc(2)           # => TRUE, but does NOT return the percentage 2.
is_perc(1/2)         # => TRUE, but does NOT return the percentage 0.5.
pc.sq <- seq(0, 100, by = 10)
is_perc(pc.sq)       # => TRUE (for vector)

# ways to fail:
is_perc(NA)          # => FALSE + warning (NA values)
is_perc(NaN)         # => FALSE + warning (NaN values)
is_perc("Bernoulli") # => FALSE + warning (non-numeric values)
is_perc(101)         # => FALSE + warning (beyond range)

}
\seealso{
\code{\link{num}} contains basic numeric variables;
\code{\link{init_num}} initializes basic numeric variables;
\code{\link{prob}} contains current probability information;
\code{\link{comp_prob}} computes current probability information;
\code{\link{freq}} contains current frequency information;
\code{\link{comp_freq}} computes current frequency information;
\code{\link{is_valid_prob_set}} verifies the validity of probability inputs;
\code{\link{as_pc}} displays a probability as a percentage;
\code{\link{as_pb}} displays a percentage as probability

Other verification functions: \code{\link{is_complement}},
  \code{\link{is_extreme_prob_set}}, \code{\link{is_freq}},
  \code{\link{is_prob}}, \code{\link{is_suff_prob_set}},
  \code{\link{is_valid_prob_pair}},
  \code{\link{is_valid_prob_set}},
  \code{\link{is_valid_prob_triple}}
}
