% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/init_txt.R
\name{init_txt}
\alias{init_txt}
\title{Initialize basic text elements.}
\usage{
init_txt(scen.lbl = txt.def$scen.lbl, scen.txt = txt.def$scen.txt,
  scen.src = txt.def$scen.src, scen.apa = txt.def$scen.apa,
  scen.lng = txt.def$scen.lng, popu.lbl = txt.def$popu.lbl,
  cond.lbl = txt.def$cond.lbl, cond.true.lbl = txt.def$cond.true.lbl,
  cond.false.lbl = txt.def$cond.false.lbl, dec.lbl = txt.def$dec.lbl,
  dec.pos.lbl = txt.def$dec.pos.lbl, dec.neg.lbl = txt.def$dec.neg.lbl,
  hi.lbl = txt.def$hi.lbl, mi.lbl = txt.def$mi.lbl,
  fa.lbl = txt.def$fa.lbl, cr.lbl = txt.def$cr.lbl)
}
\arguments{
\item{scen.lbl}{The current scenario title (sometimes in Title Caps).}

\item{scen.txt}{A longer text description of the current scenario
(which may extend over several lines).}

\item{scen.src}{The source information for the current scenario.}

\item{scen.apa}{Source information in APA format.}

\item{scen.lng}{Language of the current scenario (as character code).
Options: \code{"en"}...English, \code{"de"}... German.}

\item{popu.lbl}{A brief description of the current target population \code{\link{popu}} or sample.}

\item{cond.lbl}{A name for the \emph{condition} or feature (e.g., some disease) currently considered.}

\item{cond.true.lbl}{A label for the \emph{presence} of the current condition
or \code{\link{cond.true}} cases (the condition's true state of TRUE).}

\item{cond.false.lbl}{A label for the \emph{absence} of the current condition
or \code{\link{cond.false}} cases (the condition's true state of FALSE).}

\item{dec.lbl}{A name for the \emph{decision} or judgment (e.g., some diagnostic test) currently made.}

\item{dec.pos.lbl}{A label for \emph{positive} decisions
or \code{\link{dec.pos}} cases (e.g., predicting the presence of the condition).}

\item{dec.neg.lbl}{A label for \emph{negative} decisions
or \code{\link{dec.neg}} cases (e.g., predicting the absence of the condition).}

\item{hi.lbl}{A label for \emph{hits} or \emph{true positives} \code{\link{hi}}
(i.e., correct decisions of the presence of the condition, when the condition is actually present).}

\item{mi.lbl}{A label for \emph{misses} or \emph{false negatives} \code{\link{mi}}
(i.e., incorrect decisions of the absence of the condition when the condition is actually present).}

\item{fa.lbl}{A label for \emph{false alarms} or \emph{false positives} \code{\link{fa}}
(i.e., incorrect decisions of the presence of the condition when the condition is actually absent).}

\item{cr.lbl}{A label for \emph{correct rejections} or \emph{true negatives} \code{\link{cr}}
(i.e., a correct decision of the absence of the condition, when the condition is actually absent).}
}
\description{
\code{init_txt} initializes basic text elements
(i.e., all titles and labels corresponding to the current scenario
and used throughout the \code{riskyr} package).
}
\details{
All textual elements that specify titles and details of the current scenario
are stored as named elements (of type character) in a list \code{txt}.
\code{\link{init_txt}} allows changing elements by assigning new character
objects to existing names.
}
\examples{
init_txt()          # => defines a list of (default) text elements
length(init_txt())  # => 16

# Customizing current text elements:
txt <- init_txt(scen.lbl = "US or Them",
                scen.src = "Some stable genius",
                popu.lbl = "We, the people")

}
\seealso{
\code{\link{txt}} for current text settings;
\code{\link{pal}} for current color settings;
\code{\link{num}} for basic numeric parameters

Other functions initializing scenario information: \code{\link{init_num}},
  \code{\link{init_pal}}
}
