% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotRisk.R
\name{plotRisk}
\alias{plotRisk}
\title{plot predicted risks}
\usage{
plotRisk(x, models, times, xlim = c(0, 1), ylim = c(0, 1), xlab, ylab, col,
  pch = 1, cex = 1, ...)
}
\arguments{
\item{x}{Object obtained with function \code{Score}}

\item{models}{Choice of two models to plot. The predicted risks of
the first (second) are shown along the x-axis (y-axis).}

\item{times}{Time point specifying the prediction horizon.}

\item{xlim}{x-axis limits}

\item{ylim}{y-axis limits}

\item{xlab}{x-axis labels}

\item{ylab}{y-axis labels}

\item{col}{colour}

\item{pch}{point type}

\item{cex}{point size}

\item{...}{Used to control the subroutines: plot, axis, lines,
barplot, legend. See \code{\link{SmartControl}}.}
}
\value{
a nice graph
}
\description{
plot predicted risks
}
\details{
Two rival prediction models are applied to the same data.
}
\examples{
## uncensored
learndat = sampleData(40,outcome="binary")
testdat = sampleData(40,outcome="binary")
lr1 = glm(Y~X1+X2+X7+X9,data=learndat,family="binomial")
lr2 = glm(Y~X3+X5+X6,data=learndat,family="binomial")
xb=Score(list("LR(X1+X2+X7+X9)"=lr1,"LR(X3+X5+X6)"=lr2),formula=Y~1,
         data=testdat,summary="risks",nullModel=0L)
plotRisk(xb)
## survival
library(survival)
learndat = sampleData(40,outcome="survival")
testdat = sampleData(40,outcome="survival")
cox1 = coxph(Surv(time,event)~X1+X2+X7+X9,data=learndat,x=TRUE)
cox2 = coxph(Surv(time,event)~X3+X5+X6,data=learndat,x=TRUE)
xs=Score(list("Cox(X1+X2+X7+X9)"=cox1,"Cox(X3+X5+X6)"=cox2),formula=Surv(time,event)~1,
         data=testdat,summary="risks",nullModel=0L)
plotRisk(xs,times=5)

}
\author{
Thomas A. Gerds <tag@biostat.ku.dk>
}
