% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/navigation.R
\name{icd}
\alias{icd}
\alias{ipwd}
\title{Get or Set Current Working Directory in iRODS}
\usage{
icd(dir)

ipwd()
}
\arguments{
\item{dir}{Collection to set as working directory.}
}
\value{
Invisibly the current directory before the change (same convention as
\code{setwd()}).
}
\description{
\code{ipwd()} and \code{icd()} are the iRODS equivalents of \code{\link[=getwd]{getwd()}} and \code{\link[=setwd]{setwd()}}
respectively. For example, whereas \code{getwd()} returns the current working directory
in the local system, \code{ipwd()} returns the current working directory in iRODS.
}
\examples{
\dontshow{if (is_irods_demo_running()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
is_irods_demo_running()

# demonstration server (requires Bash, Docker and Docker-compose)
# use_irods_demo()

# connect project to server
create_irods("http://localhost/irods-rest/0.9.3", "/tempZone/home")

# authenticate
iauth("rods", "rods")

# default dir
icd(".")
ipwd()

# relative paths work as well
icd("/tempZone/home")
ipwd()

# go back on level lower
icd("..")
ipwd()

# absolute paths work as well
icd("/tempZone/home/rods")
ipwd()

# back home
icd("/tempZone/home")
\dontshow{\}) # examplesIf}
}
\seealso{
\code{\link[=setwd]{setwd()}} and \code{\link[=getwd]{getwd()}} for R equivalents,
\code{\link[=ils]{ils()}} for listing collections and objects in iRODS.
}
