% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wilcoxon.R
\name{wilcoxon}
\alias{wilcoxon}
\alias{wilcoxon.do}
\alias{print.wilcoxon}
\alias{wilcoxon.default}
\title{Wilcoxon Signed Rank and Mann-Whitney-Wilcoxon Rank Sum Test}
\usage{
wilcoxon(
  var1,
  var2 = NULL,
  alternative = "two.sided",
  null.hypoth = 0,
  paired = FALSE,
  exact = FALSE,
  correct = FALSE,
  conf.int = FALSE,
  conf.level = 0.95
)
}
\arguments{
\item{var1}{numeric vector of data values.
Non-finite (missing or infinite) values will be omitted.}

\item{var2}{optional numeric vector of data
values. Non-finite (missing or infinite) values will be omitted.}

\item{alternative}{specifies the
alternative hypothesis for the test; acceptable values are
\code{"two.sided"}, \code{"greater"}, or \code{"less"}.}

\item{null.hypoth}{the value of the null
hypothesis.}

\item{paired}{logical indicating whether
the data are paired or not. Default is \code{FALSE}. If \code{TRUE}, data
must be the same length.}

\item{exact}{logical value indicating
whether or not an exact test should be computed.}

\item{correct}{logical indicating whether
or not a continuity correction should be used and displayed.}

\item{conf.int}{logical indicating whether
or not to calculate and display a confidence interval}

\item{conf.level}{confidence level for the
interval. Defaults to 0.95.}
}
\value{
A list of class \code{wilcoxon}
is returned. The print method lays out the information in an easy-to-read
format. 
\item{statistic}{the value of the test
statistic with a name describing it.} 
\item{parameter}{the parameter(s) for
the exact distribution of the test statistic.} 
\item{p.value}{the p-value
for the test (calculated for the test statistic).} 
\item{null.value}{the
parameter \code{null.hypoth}.} 
\item{alternative}{character string describing the
alternative hypothesis.} 
\item{method}{the type of test applied.}
\item{data.name}{a character string giving the names of the data.}
\item{conf.int}{a confidence interval for the location parameter (only
present if the argument \code{conf.int=TRUE}).} 
\item{estimate}{an estimate
of the location parameter (only present if the argument
\code{conf.int=TRUE}).} 
\item{table}{a formatted table of rank sum and
number of observation values, for printing.} \item{vars}{a formatted table
of variances, for printing.} 
\item{hyps}{a formatted table of the
hypotheses, for printing.} 
\item{inf}{a formatted table of inference values,
for printing.}
}
\description{
Performs Wilcoxon signed rank test or Mann-Whitney-Wilcoxon rank sum test
depending on data and logicals entered. Relies heavily on the function
\code{\link[stats]{wilcox.test}}. Adds formatting and variances.
}
\details{
In the one-sample case, the returned confidence interval (when \code{conf.int = TRUE})
is a confidence interval for the pseudo-median of the underlying distribution. In the two-sample 
case, the function returns a confidence interval for the median of the difference between samples from 
the two distributions. See \code{\link[stats]{wilcox.test}} for more information.
}
\examples{

#- Create the data -#
cf <- c(1153, 1132, 1165, 1460, 1162, 1493, 1358, 1453, 1185, 1824, 1793, 1930, 2075)
healthy <- c(996, 1080, 1182, 1452, 1634, 1619, 1140, 1123, 1113, 1463, 1632, 1614, 1836)

#- Perform the test -#
wilcoxon(cf, healthy, paired=TRUE)

#- Perform the test -#
wilcoxon(cf, healthy, conf.int=TRUE)

}
\seealso{
\code{\link[stats]{wilcox.test}}
}
