% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/idig_top_records.R
\name{idig_top_records}
\alias{idig_top_records}
\title{Top records endpoint}
\usage{
idig_top_records(rq = FALSE, top_fields = FALSE, count = 0, ...)
}
\arguments{
\item{rq}{iDigBio record query in nested list format}

\item{top_fields}{vector of field names to summarize by}

\item{count}{maximum number of results to return, capped at 1000}

\item{...}{additional parameters}
}
\value{
nested list of field values with counts of specimen records
}
\description{
Top specimen records summaries.
}
\details{
Summarize the count of specimen records in iDigBio according to unique 
values in the fields passed. This operates similarly to a SELECT DISTINCT 
count(field_name) query in SQL. When multiple fields are passed, the 
summaries are nested eg fields=c("country", "genus") would result in 
counting the top 10 genera in each of the top 10 countries for a total of 
100 counts.
}
\author{
Matthew Collins
}
