% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/callback-sep3.R
\name{sep3}
\alias{sep3}
\alias{delta_cummin}
\alias{delta_start}
\alias{delta_min}
\title{Sepsis 3 label}
\usage{
sep3(
  ...,
  si_window = c("first", "last", "any"),
  delta_fun = delta_cummin,
  sofa_thresh = 2L,
  si_lwr = hours(48L),
  si_upr = hours(24L),
  keep_components = FALSE,
  interval = NULL
)

delta_cummin(x)

delta_start(x)

delta_min(x, shifts = seq.int(0L, 23L))
}
\arguments{
\item{...}{Data objects}

\item{si_window}{Switch that can be used to filter SI windows}

\item{delta_fun}{Function used to determine the SOFA increase during an SI
window}

\item{sofa_thresh}{Required SOFA increase to trigger Sepsis 3}

\item{si_lwr, si_upr}{Lower/upper extent of SI windows}

\item{keep_components}{Logical flag indicating whether to return the
individual components alongside the aggregated score}

\item{interval}{Time series interval (only used for checking consistency
of input data)}

\item{x}{Vector of SOFA scores}

\item{shifts}{Vector of time shifts (multiples of the current interval) over
which \code{\link[base:Extremes]{base::pmin()}} is evaluated}
}
\description{
The sepsis 3 label consists of a suspected infection combined with an acute
increase in SOFA score.
}
\details{
The Sepsis-3 Consensus (Singer et. al.) defines sepsis as an acute
increase in the SOFA score (see \code{\link[=sofa_score]{sofa_score()}}) of 2 points or more within
the suspected infection (SI) window (see \code{\link[=susp_inf]{susp_inf()}}):

\if{html}{\out{<div class="sourceCode {tikz sofa-sep-3, echo = FALSE}">}}\preformatted{\\begin\{tikzpicture\}
  \\draw (-6,0) -- (3,0);
  \\draw (-6,-0.25) -- (-6,0.25);
  \\draw (3,-0.25) -- (3,0.25);
  \\draw (0,-0.25) -- (0,0.25);
  \\node[align = center] at (0,-0.75) \{SI time\};
  \\node[align = center] at (3,-0.75) \{SI window\\\\ end\};
  \\node[align = center] at (-6,-0.75) \{SI window\\\\ start\};
  \\filldraw  (-6, 1) circle (2pt);
  \\draw (-6,1) -- (-5.5, 1);
  \\filldraw (-5.5, 1) circle (2pt);
  \\draw (-5.5,1) -- (-5, 1);
  \\node at (-4.25, 1) \{$\\dots$\} ;
  \\filldraw (-5, 1) circle (2pt);
  \\filldraw (-3.5, 1) circle (2pt);
  \\filldraw (-3, 1.5) circle (2pt);
  \\filldraw (-2.5, 1.5) circle (2pt);
  \\filldraw (-2, 2.5) circle (2pt);
  \\draw (-3.5,1) -- (-3, 1.5);
  \\draw (-3,1.5) -- (-2.5, 1.5);
  \\draw (-2.5,1.5) -- (-2, 2.5);
  \\node [black] at (-0.25, 1.75) \{$\\Delta$SOFA $\\geq 2$\};
  \\draw (-6.5, 1) -- (-6.5, 2.5) ;
  \\node at (-6.5, 3) \{SOFA\} ;
  \\draw (-6.5,1)--(-6.6,1) node[left,font=\\small]\{$0$\};
  \\draw (-6.5,1.5)--(-6.6,1.5) node[left,font=\\small]\{$1$\};
  \\draw (-6.5,2)--(-6.6,2) node[left,font=\\small]\{$2$\};
  \\draw (-6.5,2.5)--(-6.6, 2.5) node[left,font=\\small]\{$3$\};
  \\draw[red] (-2,-0.25) -- (-2,0.25);
  \\draw[dashed,red] (-2, 2.35) -- (-2, 0) ;
  \\node[red] at (-2, -0.75) \{Sepsis-3 time\};
\\end\{tikzpicture\}
}\if{html}{\out{</div>}}

A patient can potentially have multiple SI windows. The argument
\code{si_window} is used to control which SI window we focus on (options are
\verb{"first", "last", "any"}).

Further, although a 2 or more point increase in the SOFA score is defined,
it is not perfectly clear to which value the increase refers. For this the
\code{delta_fun} argument is used. If the increase is required to happen with
respect to the minimal SOFA value (within the SI window) up to the current
time, the \code{delta_cummin} function should be used. If, however, we are
looking for an increase with respect to the start of the SI window, then
the \code{delta_start} function should be used. Lastly, the increase might be
defined with respect to values of the previous 24 hours, in which case the
\code{delta_min} function is used.
}
\references{
Singer M, Deutschman CS, Seymour CW, et al. The Third International
Consensus Definitions for Sepsis and Septic Shock (Sepsis-3). JAMA.
2016;315(8):801–810. doi:10.1001/jama.2016.0287
}
