% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sources.R
\name{push.gamma}
\alias{push.gamma}
\title{Add a gamma distribution to a calibrated date}
\usage{
push.gamma(
  y,
  er,
  mean,
  shape,
  add = TRUE,
  subtract = FALSE,
  seed = NA,
  n = 1e+06,
  prob = 0.95,
  cc = 1,
  postbomb = FALSE,
  deltaR = 0,
  deltaSTD = 0,
  thiscurve = NULL,
  cc.dir = NULL,
  is.F = FALSE,
  normal = TRUE,
  t.a = 3,
  t.b = 4,
  BCAD = FALSE,
  cal.lim = c(),
  calib.col = rgb(0, 0, 0, 0.25),
  pushed.col = rgb(0, 0, 1, 0.4),
  heights = 0.3,
  inset = TRUE,
  inset.col = "darkgreen",
  inset.loc = c(0.6, 0.97, 0.6, 0.97),
  inset.mar = c(3, 0.5, 0.5, 0.5),
  inset.mgp = c(2, 1, 0)
)
}
\arguments{
\item{y}{The radiocarbon age}

\item{er}{The error of the radiocarbon age}

\item{mean}{The mean of the gamma distribution}

\item{shape}{The shape of the gamma distribution. If setting this to shape=1, it becomes an exponential distribution.}

\item{add}{The distribution can be added or subtracted. Adding results in ages being pushed to older age distributions, and subtracting to younger ones.}

\item{subtract}{The distribution can be added or subtracted. Adding results in ages being pushed to older age distributions, and subtracting to younger ones. Defaults to \code{subtract=FALSE}. If set to TRUE, overrides 'add'.}

\item{seed}{For reproducibility, a seed can be set (e.g., \code{seed=123}). Defaults to NA, no seed set.}

\item{n}{The amount of random values to sample (from both the calibrated distribution and the gamma distribution) to calculate the push. Defaults to \code{n=1e6}.}

\item{prob}{The probability for the hpd ranges. Defaults to \code{prob=0.95}.}

\item{cc}{Calibration curve to use. Defaults to IntCal20 (\code{cc=1}).}

\item{postbomb}{Whether or not to use a postbomb curve. Required for negative radiocarbon ages. Defaults to \code{postbomb=FALSE}.}

\item{deltaR}{Age offset (e.g. for marine samples).}

\item{deltaSTD}{Uncertainty of the age offset (1 standard deviation).}

\item{thiscurve}{As an alternative to providing cc and/or postbomb, the data of a specific curve can be provided (3 columns: cal BP, C14 age, error).}

\item{cc.dir}{Directory of the calibration curves. Defaults to where the package's files are stored (system.file), but can be set to, e.g., \code{cc.dir="curves"}.}

\item{is.F}{Use this if the provided date is in the F14C timescale.}

\item{normal}{Use the normal distribution to calibrate dates (default TRUE). The alternative is to use the t model (Christen and Perez 2016).}

\item{t.a}{Value a of the t distribution (defaults to 3).}

\item{t.b}{Value b of the t distribution (defaults to 4).}

\item{BCAD}{Which calendar scale to use. Defaults to cal BP, \code{BCAD=FALSE}.}

\item{cal.lim}{Calendar axis limits. Calculated automatically by default.}

\item{calib.col}{Colour of the calibrated distribution (defaults to semi-transparent light grey).}

\item{pushed.col}{Colour of the pushed distribution (defaults to semi-transparent blue).}

\item{heights}{Heights of the calibrated and 'pushed' distributions. Defaults to 0.3 of the device's height.}

\item{inset}{Whether or not to plot an inset graph showing the shape of the normal/gamma distribution.}

\item{inset.col}{Colour of the normal/gamma distribution.}

\item{inset.loc}{Location of the inset graph.}

\item{inset.mar}{Margins of the inset graph.}

\item{inset.mgp}{Margin lines for the inset graph.}
}
\value{
The resulting calibrated distribution and its hpd ranges, together with a plot of the pushed date with the gamma distribution (and whether it is added or subtracted) as inset
}
\description{
Push a date to younger or older ages by adding (or subtracting) a gamma distribution (e.g. if a bone is assumed to have a lag or in-built age)
}
\details{
n random values will be sampled from the calibrated distribution, and a similar amount will be sampled from the gamma distribution. The sampled values will then be added to or subtracted from each other to push the date to younger or older ages.
}
\examples{
  push.gamma(250, 25, 50, 2, add=FALSE) # subtract a gamma distribution
}
