% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/file_dir.R
\name{checkFile}
\alias{checkFile}
\alias{assertFile}
\title{Check whether file(s) exist}
\usage{
checkFile(...)

assertFile(...)
}
\arguments{
\item{\dots}{Files to be checked}
}
\value{
\code{checkFile} returns logical vector. \code{assertFile} returns
an invisible \code{TRUE} if files exist, otherwise halts and prints error
messages.
}
\description{
\code{checkFile} checks whether file exists, \code{assertFile} stops the
program if files do not exist
}
\details{
\code{assertFile} is often used in scripts where missing a file would cause
the script fail.
}
\examples{

myDesc <- system.file("DESCRIPTION", package="ribiosUtils")
myNEWS <- system.file("NEWS", package="ribiosUtils")
checkFile(myDesc, myNEWS)
assertFile(myDesc, myNEWS)

}
\seealso{
\code{\link{isDir}} and \code{\link{assertDir}}
}
\author{
Jitao David Zhang <jitao_david.zhang@roche.com>
}
